/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import com.alipay.sofa.rpc.common.utils.IOUtils;
import com.alipay.sofa.rpc.common.utils.ReflectUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String getBaseDirName() {
        String fileName = null;
        URL url1 = FileUtils.class.getResource("/");
        if (url1 != null) {
            fileName = url1.getFile();
        } else {
            String jarpath = ReflectUtils.getCodeBase(FileUtils.class);
            if (jarpath != null) {
                int sofaidx = jarpath.lastIndexOf("sofa");
                if (sofaidx > -1) {
                    fileName = jarpath.substring(0, sofaidx);
                } else {
                    int sepidx = jarpath.lastIndexOf(File.separator);
                    if (sepidx > -1) {
                        fileName = jarpath.substring(0, sepidx + 1);
                    }
                }
            }
        }
        if (fileName != null) {
            if ((fileName = fileName.replace(":", "").replace(File.separator, "/").replace("/", "-")).startsWith("-")) {
                fileName = fileName.substring(1);
            }
        } else {
            fileName = "UNKNOW_";
        }
        return fileName;
    }

    public static String getUserHomeDir(String base) {
        String userhome = System.getProperty("user.home");
        File file = new File(userhome, base);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new SofaRpcRuntimeException(file.getAbsolutePath() + " exists, but not directory");
            }
        } else {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(File file) throws IOException {
        String string;
        if (!(file != null && file.exists() && file.isFile() && file.canRead())) {
            return null;
        }
        FileReader reader = null;
        StringWriter writer = null;
        try {
            reader = new FileReader(file);
            writer = new StringWriter();
            char[] cbuf = new char[1024];
            int len = 0;
            while ((len = reader.read(cbuf)) != -1) {
                writer.write(cbuf, 0, len);
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(writer);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file2String(Class clazz, String relativePath, String encoding) throws IOException {
        InputStream is = null;
        InputStreamReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            String lineText;
            is = clazz.getResourceAsStream(relativePath);
            reader = new InputStreamReader(is, encoding);
            bufferedReader = new BufferedReader(reader);
            StringBuilder context = new StringBuilder();
            while ((lineText = bufferedReader.readLine()) != null) {
                context.append(lineText).append(LINE_SEPARATOR);
            }
            String string = context.toString();
            return string;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        FileReader reader = null;
        BufferedReader bufferedReader = null;
        try {
            reader = new FileReader(file);
            bufferedReader = new BufferedReader(reader);
            String lineText = null;
            while ((lineText = bufferedReader.readLine()) != null) {
                lines.add(lineText);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean string2File(File file, String data) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, false);
            writer.write(data);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return true;
    }

    public static boolean cleanDirectory(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String aChildren : children) {
                boolean success = FileUtils.cleanDirectory(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

