/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.bootstrap.Bootstraps;
import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;

public class ProviderConfig<T>
extends AbstractInterfaceConfig<T, ProviderConfig<T>>
implements Serializable {
    private static final long serialVersionUID = -3058073881775315962L;
    protected transient T ref;
    protected List<ServerConfig> server;
    protected int delay = RpcConfigs.getIntValue("provider.delay");
    protected int weight = RpcConfigs.getIntValue("provider.weight");
    protected String include = RpcConfigs.getStringValue("provider.include");
    protected String exclude = RpcConfigs.getStringValue("provider.exclude");
    protected boolean dynamic = RpcConfigs.getBooleanValue("provider.dynamic");
    protected int priority = RpcConfigs.getIntValue("provider.priority");
    protected String bootstrap;
    protected transient ThreadPoolExecutor executor;
    protected int timeout = RpcConfigs.getIntValue("provider.invoke.timeout");
    protected int concurrents = RpcConfigs.getIntValue("provider.concurrents");
    protected int repeatedExportLimit = RpcConfigs.getIntValue("provider.repeated.export.limit");
    protected volatile transient ConcurrentHashMap<String, Boolean> methodsLimit;
    protected transient ProviderBootstrap providerBootstrap;

    @Override
    public Class<?> getProxyClass() {
        block6: {
            if (this.proxyClass != null) {
                return this.proxyClass;
            }
            try {
                if (StringUtils.isNotBlank(this.interfaceId)) {
                    this.proxyClass = ClassUtils.forName(this.interfaceId);
                    if (!this.proxyClass.isInterface()) {
                        throw ExceptionUtils.buildRuntime("service.interfaceId", this.interfaceId, "interfaceId must set interface class, not implement class");
                    }
                    break block6;
                }
                throw ExceptionUtils.buildRuntime("service.interfaceId", "null", "interfaceId must be not null");
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new SofaRpcRuntimeException(e.getMessage(), e);
            }
        }
        return this.proxyClass;
    }

    @Override
    public String buildKey() {
        return this.interfaceId + ":" + this.uniqueId;
    }

    public T getRef() {
        return this.ref;
    }

    public ProviderConfig<T> setRef(T ref) {
        this.ref = ref;
        return this;
    }

    public List<ServerConfig> getServer() {
        return this.server;
    }

    public ProviderConfig<T> setServer(List<ServerConfig> server) {
        this.server = server;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    public ProviderConfig<T> setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public ProviderConfig<T> setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public String getInclude() {
        return this.include;
    }

    public ProviderConfig<T> setInclude(String include) {
        this.include = include;
        return this;
    }

    public String getExclude() {
        return this.exclude;
    }

    public ProviderConfig<T> setExclude(String exclude) {
        this.exclude = exclude;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public ProviderConfig<T> setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ProviderConfig<T> setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public String getBootstrap() {
        return this.bootstrap;
    }

    public ProviderConfig<T> setBootstrap(String bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public ProviderConfig<T> setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
        return this;
    }

    public int getConcurrents() {
        return this.concurrents;
    }

    public ProviderConfig<T> setConcurrents(int concurrents) {
        this.concurrents = concurrents;
        return this;
    }

    public int getRepeatedExportLimit() {
        return this.repeatedExportLimit;
    }

    public ProviderConfig<T> setRepeatedExportLimit(int repeatedExportLimit) {
        this.repeatedExportLimit = repeatedExportLimit;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ProviderConfig setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public boolean hasTimeout() {
        if (this.timeout > 0) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (methodConfig.getTimeout() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasConcurrents() {
        if (this.concurrents > 0) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (methodConfig.getConcurrents() == null || methodConfig.getConcurrents() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public ProviderConfig<T> setServer(ServerConfig server) {
        if (this.server == null) {
            this.server = new ArrayList<ServerConfig>();
        }
        this.server.add(server);
        return this;
    }

    public Map<String, Boolean> getMethodsLimit() {
        return this.methodsLimit;
    }

    public ProviderConfig<T> setMethodsLimit(ConcurrentHashMap<String, Boolean> methodsLimit) {
        this.methodsLimit = methodsLimit;
        return this;
    }

    public synchronized void export() {
        if (this.providerBootstrap == null) {
            this.providerBootstrap = Bootstraps.from(this);
        }
        this.providerBootstrap.export();
    }

    public synchronized void unExport() {
        if (this.providerBootstrap != null) {
            this.providerBootstrap.unExport();
        }
    }

    public ProviderBootstrap getProviderBootstrap() {
        return this.providerBootstrap;
    }
}

