/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.LookoutSubscriber;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.event.ServerStartedEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.module.Module;

@Extension(value="lookout")
public class LookoutModule
implements Module {
    private LookoutSubscriber subscriber;

    @Override
    public boolean needLoad() {
        try {
            Class.forName("com.alipay.lookout.spi.DefaultMetricsImporterLocator");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void install() {
        this.subscriber = new LookoutSubscriber();
        EventBus.register(ClientEndInvokeEvent.class, this.subscriber);
        EventBus.register(ServerSendEvent.class, this.subscriber);
        EventBus.register(ServerStartedEvent.class, this.subscriber);
    }

    @Override
    public void uninstall() {
        if (this.subscriber != null) {
            EventBus.unRegister(ClientEndInvokeEvent.class, this.subscriber);
            EventBus.unRegister(ServerSendEvent.class, this.subscriber);
            EventBus.unRegister(ServerStartedEvent.class, this.subscriber);
        }
    }
}

