/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.zk.AbstractZookeeperObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperOverrideObserver
extends AbstractZookeeperObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperOverrideObserver.class);
    private ConcurrentHashMap<AbstractInterfaceConfig, List<ConfigListener>> configListenerMap = new ConcurrentHashMap();

    public void addConfigListener(AbstractInterfaceConfig config, ConfigListener listener) {
        if (listener != null) {
            this.initOrAddList(this.configListenerMap, config, listener);
        }
    }

    public void removeConfigListener(AbstractInterfaceConfig config) {
        this.configListenerMap.remove(config);
    }

    public void updateConfig(AbstractInterfaceConfig config, String overridePath, ChildData data) throws Exception {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertOverrideToAttribute(overridePath, data, false, null);
                for (ConfigListener listener : configListeners) {
                    listener.attrUpdated(attribute);
                }
            }
        }
    }

    public void updateConfigAll(AbstractInterfaceConfig config, String overridePath, List<ChildData> currentData) throws UnsupportedEncodingException {
        if (CommonUtils.isEmpty(currentData)) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                for (ChildData data : currentData) {
                    LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
                }
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                List<Map<String, String>> attributes = ZookeeperRegistryHelper.convertOverrideToAttributes(config, overridePath, currentData);
                for (ConfigListener listener : configListeners) {
                    for (Map<String, String> attribute : attributes) {
                        listener.attrUpdated(attribute);
                    }
                }
            }
        }
    }

    public void removeConfig(AbstractInterfaceConfig config, String overridePath, ChildData data, AbstractInterfaceConfig registerConfig) throws Exception {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else if (registerConfig == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Register config is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertOverrideToAttribute(overridePath, data, true, registerConfig);
                for (ConfigListener listener : configListeners) {
                    listener.attrUpdated(attribute);
                }
            }
        }
    }

    public void addConfig(AbstractInterfaceConfig config, String overridePath, ChildData data) throws Exception {
        if (data == null) {
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data is null");
            }
        } else {
            List<ConfigListener> configListeners;
            if (LOGGER.isInfoEnabled(config.getAppName())) {
                LOGGER.infoWithApp(config.getAppName(), "Receive data: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
            }
            if (CommonUtils.isNotEmpty(configListeners = this.configListenerMap.get(config))) {
                Map<String, String> attribute = ZookeeperRegistryHelper.convertOverrideToAttribute(overridePath, data, false, null);
                for (ConfigListener listener : configListeners) {
                    listener.attrUpdated(attribute);
                }
            }
        }
    }
}

