/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.zk;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.zk.AbstractZookeeperObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperConfigObserver;
import com.alipay.sofa.rpc.registry.zk.ZookeeperRegistryHelper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.recipes.cache.ChildData;

public class ZookeeperProviderObserver
extends AbstractZookeeperObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperConfigObserver.class);
    private ConcurrentHashMap<ConsumerConfig, List<ProviderInfoListener>> providerListenerMap = new ConcurrentHashMap();

    public void addProviderListener(ConsumerConfig consumerConfig, ProviderInfoListener listener) {
        if (listener != null) {
            this.initOrAddList(this.providerListenerMap, consumerConfig, listener);
        }
    }

    public void removeProviderListener(ConsumerConfig consumerConfig) {
        this.providerListenerMap.remove(consumerConfig);
    }

    public void updateProvider(ConsumerConfig config, String providerPath, ChildData data) throws UnsupportedEncodingException {
        List<ProviderInfoListener> providerInfoListeners;
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive update provider: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
        }
        if (CommonUtils.isNotEmpty(providerInfoListeners = this.providerListenerMap.get(config))) {
            List<ProviderInfo> providerInfos = Arrays.asList(ZookeeperRegistryHelper.convertUrlToProvider(providerPath, data));
            for (ProviderInfoListener listener : providerInfoListeners) {
                List<ProviderInfo> providerInfosForProtocol = this.filterByProtocol(config.getProtocol(), providerInfos);
                listener.addProvider(new ProviderGroup(providerInfosForProtocol));
            }
        }
    }

    public void removeProvider(ConsumerConfig config, String providerPath, ChildData data) throws UnsupportedEncodingException {
        List<ProviderInfoListener> providerInfoListeners;
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive remove provider: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
        }
        if (CommonUtils.isNotEmpty(providerInfoListeners = this.providerListenerMap.get(config))) {
            List<ProviderInfo> providerInfos = Arrays.asList(ZookeeperRegistryHelper.convertUrlToProvider(providerPath, data));
            List<ProviderInfo> providerInfosForProtocol = this.filterByProtocol(config.getProtocol(), providerInfos);
            for (ProviderInfoListener listener : providerInfoListeners) {
                listener.removeProvider(new ProviderGroup(providerInfosForProtocol));
            }
        }
    }

    public void addProvider(ConsumerConfig config, String providerPath, ChildData data) throws UnsupportedEncodingException {
        List<ProviderInfoListener> providerInfoListeners;
        if (LOGGER.isInfoEnabled(config.getAppName())) {
            LOGGER.infoWithApp(config.getAppName(), "Receive add provider: path=[" + data.getPath() + "]" + ", data=[" + StringSerializer.decode(data.getData()) + "]" + ", stat=[" + data.getStat() + "]");
        }
        if (CommonUtils.isNotEmpty(providerInfoListeners = this.providerListenerMap.get(config))) {
            List<ProviderInfo> providerInfos = Arrays.asList(ZookeeperRegistryHelper.convertUrlToProvider(providerPath, data));
            for (ProviderInfoListener listener : providerInfoListeners) {
                List<ProviderInfo> providerInfosForProtocol = this.filterByProtocol(config.getProtocol(), providerInfos);
                listener.addProvider(new ProviderGroup(providerInfosForProtocol));
            }
        }
    }

    private List<ProviderInfo> filterByProtocol(String protocol, List<ProviderInfo> providerInfos) {
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        for (ProviderInfo providerInfo : providerInfos) {
            if (!providerInfo.getProtocolType().equalsIgnoreCase(protocol)) continue;
            result.add(providerInfo);
        }
        return result;
    }
}

