/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server;

import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.ThreadPoolUtils;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.transport.ServerTransportConfig;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class BusinessPool {
    public static synchronized ThreadPoolExecutor initPool(ServerTransportConfig transportConfig) {
        int aliveTime;
        int minPoolSize;
        int maxPoolSize = transportConfig.getBizMaxThreads();
        String poolType = transportConfig.getBizPoolType();
        if ("fixed".equals(poolType)) {
            minPoolSize = maxPoolSize;
            aliveTime = 0;
        } else if ("cached".equals(poolType)) {
            minPoolSize = 20;
            maxPoolSize = Math.max(minPoolSize, maxPoolSize);
            aliveTime = 60000;
        } else {
            throw ExceptionUtils.buildRuntime("server.threadPoolType", poolType);
        }
        String queueType = transportConfig.getBizPoolQueueType();
        int queueSize = transportConfig.getBizPoolQueues();
        boolean isPriority = "priority".equals(queueType);
        BlockingQueue<Runnable> configQueue = ThreadPoolUtils.buildQueue(queueSize, isPriority);
        return new ThreadPoolExecutor(minPoolSize, maxPoolSize, aliveTime, TimeUnit.MILLISECONDS, configQueue);
    }

    public static ThreadPoolExecutor initPool(ServerConfig serverConfig) {
        int minPoolSize = serverConfig.getCoreThreads();
        int maxPoolSize = serverConfig.getMaxThreads();
        int queueSize = serverConfig.getQueues();
        int aliveTime = serverConfig.getAliveTime();
        BlockingQueue poolQueue = (BlockingQueue)((Object)(queueSize > 0 ? new LinkedBlockingQueue(queueSize) : new SynchronousQueue()));
        return new ThreadPoolExecutor(minPoolSize, maxPoolSize, aliveTime, TimeUnit.MILLISECONDS, poolQueue);
    }
}

