/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer;

import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.tracer.Tracer;

public final class TracerFactory {
    public static synchronized Tracer getTracer(String tracerName) {
        try {
            ExtensionClass<Tracer> ext = ExtensionLoaderFactory.getExtensionLoader(Tracer.class).getExtensionClass(tracerName);
            if (ext == null) {
                throw ExceptionUtils.buildRuntime("tracer.name", tracerName);
            }
            return ext.getExtInstance();
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(e.getMessage(), e);
        }
    }
}

