/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.auth;

import com.aliyun.openservices.iot.api.Profile;
import com.aliyun.openservices.iot.api.auth.AuthHandler;
import com.aliyun.openservices.iot.api.auth.handler.AppKeyAuthHandler;
import com.aliyun.openservices.iot.api.auth.handler.DeviceAuthHandler;
import com.aliyun.openservices.iot.api.auth.handler.accesskey.AccessKeyAuthHandler;
import com.aliyun.openservices.iot.api.exception.IotClientException;
import com.google.common.collect.Maps;
import java.util.Map;

public class AuthenticationFactory {
    private static Map<String, AuthHandler> authHandlers = Maps.newHashMap();

    public static AuthHandler getAuthHandler(Profile profile) {
        Map<String, String> params = profile.getAuthParams();
        if (params == null || params.isEmpty()) {
            throw new IotClientException("authorization parameter is empty");
        }
        String authType = profile.getAuthParams().get("name");
        if ("aliyunak".equals(authType)) {
            return new AccessKeyAuthHandler(params);
        }
        if ("devicename".equals(authType)) {
            return new DeviceAuthHandler(params);
        }
        if ("appkey".equals(authType)) {
            return new AppKeyAuthHandler(params);
        }
        if (authHandlers.containsKey(authType)) {
            return authHandlers.get(authType);
        }
        throw new IotClientException("unsupported auth type: " + authType);
    }

    public static void registerAuthHandler(String authType, AuthHandler authHandler) {
        authHandlers.put(authType, authHandler);
    }

    public static void unregisterAuthHandler(String authType) {
        authHandlers.remove(authType);
    }
}

