/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.stream;

import com.aliyun.openservices.iot.api.http2.IotHttp2Client;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.http2.connection.StreamWriteOperation;
import com.aliyun.openservices.iot.api.http2.entity.BaseHttpEntity;
import com.aliyun.openservices.iot.api.http2.entity.Http2Response;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServiceContext {
    private static final Logger log = LoggerFactory.getLogger(StreamServiceContext.class);
    public static final String RESPONSE_STATUS = "x-response-status";
    private BaseHttpEntity sourceRequest;
    private Connection connection;
    private IotHttp2Client client;
    private String serviceName;

    public StreamServiceContext(IotHttp2Client client, Connection connection, BaseHttpEntity request, String serviceName) {
        this.client = client;
        this.connection = connection;
        this.sourceRequest = request;
        this.serviceName = serviceName;
    }

    public void writeResponse(Http2Response response) {
        Http2Headers headers = response.getHeaders();
        headers.add((Object)"x-request-id", (Object)this.sourceRequest.getRequestId());
        headers.add((Object)RESPONSE_STATUS, (Object)headers.status());
        headers.add((Object)"x-data-stream-id", (Object)this.getStreamId());
        headers.path(this.sourceRequest.getHeaders().path());
        headers.method((CharSequence)"POST");
        headers.scheme((CharSequence)"https");
        headers.remove((Object)Http2Headers.PseudoHeaderName.STATUS.value());
        byte[] data = response.getContent();
        boolean endOfStream = data == null || data.length == 0;
        CompletableFuture<StreamWriteOperation> future = this.connection.writeHeaders(headers, endOfStream, null);
        if (!endOfStream) {
            future.thenAccept(writeOperation -> writeOperation.writeData(response.getContent(), true));
        }
        future.thenAccept(StreamWriteOperation::closeStream);
    }

    public String getStreamId() {
        if (this.sourceRequest.getHeaders().contains((Object)"x-data-stream-id")) {
            return ((CharSequence)this.sourceRequest.getHeaders().get((Object)"x-data-stream-id")).toString();
        }
        return null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void updateContext(BaseHttpEntity httpEntity) {
        this.sourceRequest.getHeaders().add((Headers)httpEntity.getHeaders());
        this.sourceRequest.getHeaders().set((Object)"x-request-id", (Object)httpEntity.getRequestId());
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

