/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.iot.api.message.entity;

import com.aliyun.openservices.iot.api.http2.IotHttp2Client;
import com.aliyun.openservices.iot.api.http2.connection.Connection;
import com.aliyun.openservices.iot.api.message.entity.Message;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageToken {
    Message message;
    private Connection connection;
    private IotHttp2Client client;
    private StopStrategy stopStrategy;
    private WaitStrategy waitStrategy;
    private MessageAttempt attempt;
    private long localMessageId;
    private CompletableFuture<Message> publishFuture;

    public MessageToken(Message message, Connection connection, IotHttp2Client client) {
        this.message = message;
        this.connection = connection;
        this.client = client;
        this.stopStrategy = StopStrategies.stopAfterAttempt((int)32);
        this.waitStrategy = WaitStrategies.exponentialWait((long)10L, (TimeUnit)TimeUnit.MINUTES);
        this.attempt = new MessageAttempt();
        this.publishFuture = new CompletableFuture();
    }

    public boolean shouldStop(boolean isLocalError) {
        if (this.message.getQos() < 1 && !isLocalError) {
            return true;
        }
        return this.stopStrategy.shouldStop((Attempt)this.attempt);
    }

    public long computeSleepTime() {
        return this.waitStrategy.computeSleepTime((Attempt)this.attempt);
    }

    public void increaseAttemptCount() {
        this.attempt.attemptCount.incrementAndGet();
    }

    public Message getMessage() {
        return this.message;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public IotHttp2Client getClient() {
        return this.client;
    }

    public StopStrategy getStopStrategy() {
        return this.stopStrategy;
    }

    public void setStopStrategy(StopStrategy stopStrategy) {
        this.stopStrategy = stopStrategy;
    }

    public WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public long getLocalMessageId() {
        return this.localMessageId;
    }

    public void setLocalMessageId(long localMessageId) {
        this.localMessageId = localMessageId;
    }

    public CompletableFuture<Message> getPublishFuture() {
        return this.publishFuture;
    }

    private static final class MessageAttempt
    implements Attempt {
        private long firstAttemptTime;
        private AtomicInteger attemptCount = new AtomicInteger(0);

        public MessageAttempt() {
            this.firstAttemptTime = System.currentTimeMillis();
        }

        public Object get() throws ExecutionException {
            return null;
        }

        public boolean hasResult() {
            return false;
        }

        public boolean hasException() {
            return false;
        }

        public Object getResult() throws IllegalStateException {
            return null;
        }

        public Throwable getExceptionCause() throws IllegalStateException {
            return null;
        }

        public long getAttemptNumber() {
            return this.attemptCount.get();
        }

        public long getDelaySinceFirstAttempt() {
            return System.currentTimeMillis() - this.firstAttemptTime;
        }
    }
}

