/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.auth.HmacSHA1Signature;
import com.alicloud.openservices.tablestore.core.auth.RequestSignerInterface;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.http.RequestMessage;
import com.alicloud.openservices.tablestore.core.utils.Bytes;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;

public class RequestSigner
implements RequestSignerInterface {
    private ServiceCredentials credentials;
    private byte[] accessKey;
    private byte[] instanceName;

    public RequestSigner(String instanceName, ServiceCredentials credentials) {
        Preconditions.checkNotNull(instanceName);
        Preconditions.checkNotNull(credentials);
        this.credentials = credentials;
        this.accessKey = Bytes.toBytes(credentials.getAccessKeySecret());
        try {
            this.instanceName = instanceName.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Unsupport encoding: iso-8859-1");
        }
    }

    @Override
    public void sign(RequestMessage request) throws ClientException {
        request.addHeader("x-ots-accesskeyid", this.credentials.getAccessKeyId());
        if (this.credentials.getStsToken() != null && !this.credentials.getStsToken().isEmpty()) {
            request.addHeader("x-ots-ststoken", this.credentials.getStsToken());
        }
        try {
            String signature = this.getSignature(request.getActionUri().getAction(), request.getRequest().getMethod(), request.getRequest().getAllHeaders());
            request.addHeader("x-ots-signature", signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("\u65e0\u6cd5\u8ba1\u7b97\u7b7e\u540d\uff1a" + e.getMessage());
        }
    }

    private String getSignature(String action, String method, Header[] headers) throws UnsupportedEncodingException {
        StringBuilder canonicalizedOtsHeader = new StringBuilder(1000);
        TreeMap<String, String> headerMap = new TreeMap<String, String>();
        for (Header header : headers) {
            headerMap.put(header.getName(), header.getValue());
        }
        for (Map.Entry entry : headerMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = ((String)entry.getValue()).trim();
            if (!key.startsWith("x-ots-")) continue;
            canonicalizedOtsHeader.append(key).append(":").append(val).append("\n");
        }
        StringBuilder sb = new StringBuilder(1000);
        sb.append("/").append(action).append("\n").append(method).append("\n").append("\n").append(canonicalizedOtsHeader.toString());
        HmacSHA1Signature signer = new HmacSHA1Signature(this.accessKey);
        signer.updateUTF8String(sb.toString());
        return signer.computeSignature();
    }
}

