/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.ShutdownException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.lease.LeaseCoordinator;
import com.aliyun.openservices.ots.internal.streamclient.lease.ShardLease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.model.ICheckpointTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckpointTracker
implements ICheckpointTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointTracker.class);
    private final ILeaseManager<ShardLease> leaseManager;
    private final LeaseCoordinator<ShardLease> leaseCoordinator;

    CheckpointTracker(ILeaseManager<ShardLease> leaseManager, LeaseCoordinator<ShardLease> leaseCoordinator) {
        this.leaseManager = leaseManager;
        this.leaseCoordinator = leaseCoordinator;
    }

    @Override
    public void setCheckpoint(String shardId, String checkpointValue, String leaseIdentifier) throws ShutdownException, StreamClientException, DependencyException {
        if (!this.setCheckpointByUpdateLease(shardId, checkpointValue, leaseIdentifier)) {
            LOG.warn("Can't update checkpoint because worker doesn't hold the lease for this shard.");
            throw new ShutdownException("Can't update checkpoint because worker doesn't hold the lease for this shard.");
        }
    }

    private boolean setCheckpointByUpdateLease(String shardId, String checkpointValue, String leaseIdentifier) throws StreamClientException, DependencyException {
        ShardLease lease = this.leaseCoordinator.getCurrentlyHeldLease(shardId);
        if (lease == null) {
            return false;
        }
        lease.setCheckpoint(checkpointValue);
        boolean result = this.leaseCoordinator.updateLease(lease, leaseIdentifier);
        LOG.debug("Set, ShardId: {}, CheckpointValue: {}", (Object)shardId, (Object)checkpointValue);
        return result;
    }

    @Override
    public String getCheckpoint(String shardId) throws StreamClientException, DependencyException {
        if (this.leaseManager.getLease(shardId) == null) {
            return null;
        }
        return this.leaseManager.getLease(shardId).getCheckpoint();
    }
}

