/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal.streamclient.core;

import com.aliyun.openservices.ots.internal.streamclient.DependencyException;
import com.aliyun.openservices.ots.internal.streamclient.StreamClientException;
import com.aliyun.openservices.ots.internal.streamclient.StreamConfig;
import com.aliyun.openservices.ots.internal.streamclient.core.task.ITask;
import com.aliyun.openservices.ots.internal.streamclient.core.task.RetryingTaskDecorator;
import com.aliyun.openservices.ots.internal.streamclient.core.task.ShardSyncTask;
import com.aliyun.openservices.ots.internal.streamclient.core.task.TaskResult;
import com.aliyun.openservices.ots.internal.streamclient.lease.ShardLease;
import com.aliyun.openservices.ots.internal.streamclient.lease.interfaces.ILeaseManager;
import com.aliyun.openservices.ots.internal.streamclient.model.IRetryStrategy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardSyncer {
    private static final Logger LOG = LoggerFactory.getLogger(ShardSyncer.class);
    private ITask currentTask;
    private Future<TaskResult> future;
    private final StreamConfig streamConfig;
    private final ILeaseManager<ShardLease> leaseManager;
    private final ExecutorService executorService;
    private final IRetryStrategy taskRetryStrategy;

    public ShardSyncer(StreamConfig streamConfig, ILeaseManager<ShardLease> leaseManager, ExecutorService executorService, IRetryStrategy taskRetryStrategy) {
        this.streamConfig = streamConfig;
        this.leaseManager = leaseManager;
        this.executorService = executorService;
        this.taskRetryStrategy = taskRetryStrategy;
    }

    private synchronized boolean checkPreviousTask(boolean synchronous) throws DependencyException, StreamClientException {
        if (this.future == null) {
            return true;
        }
        if (synchronous || this.future.isDone()) {
            try {
                TaskResult result = this.future.get();
                if (result.getException() != null) {
                    throw result.getException();
                }
            }
            catch (DependencyException e) {
                LOG.error("SyncTask failed", (Throwable)e);
                throw e;
            }
            catch (StreamClientException e) {
                LOG.error("SyncTask failed", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                LOG.error("SyncTask failed", (Throwable)e);
                throw new StreamClientException("ShardSyncError.", e);
            }
            return true;
        }
        return false;
    }

    public synchronized boolean syncShardAndLeaseInfo(boolean synchronous) throws StreamClientException, DependencyException {
        boolean submitted = this.checkAndSubmitNextTask(synchronous);
        LOG.debug("SyncShard, Synchronous: {}, Submitted: {}.", (Object)synchronous, (Object)submitted);
        return submitted;
    }

    private synchronized boolean checkAndSubmitNextTask(boolean synchronous) throws StreamClientException, DependencyException {
        LOG.debug("check and submit next task. Synchronous: {}.", (Object)synchronous);
        boolean previousTaskDone = this.checkPreviousTask(synchronous);
        if (previousTaskDone) {
            ShardSyncTask task = new ShardSyncTask(this.streamConfig, this.leaseManager);
            this.currentTask = new RetryingTaskDecorator(IRetryStrategy.RetryableAction.TASK_SHARDSYNC, this.taskRetryStrategy, task);
            this.future = this.executorService.submit(this.currentTask);
            if (synchronous) {
                this.checkPreviousTask(synchronous);
            }
            return true;
        }
        return false;
    }
}

