/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.thread;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public enum TaskManager {
    SINGLETON;

    private static final Logger LOGGER;
    private ThreadPoolExecutor executor;

    private void init() {
        SynchronousQueue<Runnable> synchronousQueue = new SynchronousQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, (long)new Long(60L), TimeUnit.SECONDS, synchronousQueue, new AtomikosThreadFactory());
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public void executeTask(Runnable task) {
        if (this.executor == null) {
            this.init();
        }
        this.executor.execute(task);
    }

    static {
        LOGGER = LoggerFactory.createLogger(TaskManager.class);
    }

    private static class AtomikosThreadFactory
    implements ThreadFactory {
        private volatile AtomicInteger count = new AtomicInteger(0);
        private final ThreadGroup group;

        private AtomikosThreadFactory() {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            String realName = "Atomikos:" + this.count.incrementAndGet();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("ThreadFactory: creating new thread: " + realName);
            }
            Thread thread = new Thread(this.group, r, realName);
            thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            thread.setDaemon(true);
            return thread;
        }
    }
}

