/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.util;

import bsh.Interpreter;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.util.NoSupportTypeCastException;
import com.frameworkset.util.SimpleStringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.frameworkset.util.DataFormatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(ValueObjectUtil.class);

    public static Object getValue(Object obj, String property) {
        return ValueObjectUtil.getValue(obj, property, null);
    }

    public static Object getValue(Object obj, String property, Object[] params) {
        if (obj == null || property == null || property.trim().length() == 0) {
            return null;
        }
        Object ret = ValueObjectUtil.getValueByMethodName(obj, ValueObjectUtil.getMethodName(property), params);
        if (ret == null && (ret = ValueObjectUtil.getValueByMethodName(obj, ValueObjectUtil.getBooleanMethodName(property), params)) != null) {
            log.debug("Get Boolean property[" + property + "=" + ret + "].");
        }
        return ret;
    }

    public static Object getValueByMethodName(Object obj, String methodName, Object[] params) {
        if (obj == null || methodName == null || methodName.trim().length() == 0) {
            return null;
        }
        return ValueObjectUtil.getValueByMethodName(obj, methodName, params, null);
    }

    public static Object getValueByMethodName(Object obj, String methodName, Object[] params, Class[] paramsTtype) {
        if (obj == null || methodName == null || methodName.trim().length() == 0) {
            return null;
        }
        try {
            Method method = obj.getClass().getMethod(methodName, paramsTtype);
            if (method != null) {
                return method.invoke(obj, params);
            }
        }
        catch (Exception e) {
            log.info("NoSuchMethodException:" + e.getMessage());
        }
        return null;
    }

    public static Object invoke(Object obj, Method method, Object[] params) throws Exception {
        return method.invoke(obj, params);
    }

    public static String getMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "get" + letter + fieldName.substring(1);
        return ret;
    }

    public static String getBooleanMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "is" + letter + fieldName.substring(1);
        return ret;
    }

    public static String getSetterMethodName(String fieldName) {
        String ret = null;
        if (fieldName == null) {
            return null;
        }
        String letter = String.valueOf(fieldName.charAt(0));
        letter = letter.toUpperCase();
        ret = "set" + letter + fieldName.substring(1);
        return ret;
    }

    public static final boolean isSameType(Class type, Class toType) {
        if (toType == Object.class) {
            return true;
        }
        if (type == toType) {
            return true;
        }
        if (toType.isAssignableFrom(type)) {
            return true;
        }
        if (type == Integer.TYPE && toType == Integer.class || type == Integer.class && toType == Integer.TYPE) {
            return true;
        }
        if (type == Short.TYPE && toType == Short.class || type == Short.class && toType == Short.TYPE) {
            return true;
        }
        if (type == Long.TYPE && toType == Long.class || type == Long.class && toType == Long.TYPE) {
            return true;
        }
        if (type == Double.TYPE && toType == Double.class || type == Double.class && toType == Double.TYPE) {
            return true;
        }
        if (type == Float.TYPE && toType == Float.class || type == Float.class && toType == Float.TYPE) {
            return true;
        }
        return type == Character.TYPE && toType == Character.class || type == Character.class && toType == Character.TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object typeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException, IllegalArgumentException {
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return toType.cast(obj);
        }
        if (type == byte[].class && toType == String.class) {
            return new String((byte[])obj);
        }
        if (type == String.class && toType == byte[].class) {
            return ((String)obj).getBytes();
        }
        if (type == byte[].class && File.class.isAssignableFrom(toType)) {
            Object[] object = (Object[])obj;
            ByteArrayInputStream byteIn = null;
            FileOutputStream fileOut = null;
            try {
                byteIn = new ByteArrayInputStream((byte[])object[0]);
                fileOut = new FileOutputStream((File)object[1]);
                byte[] v = new byte[1024];
                int i = 0;
                while ((i = byteIn.read(v)) > 0) {
                    fileOut.write(v, 0, i);
                }
                fileOut.flush();
                Object object2 = object[1];
                return object2;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (byteIn != null) {
                        byteIn.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (fileOut != null) {
                        fileOut.close();
                    }
                }
                catch (Exception e) {}
            }
        } else {
            if (File.class.isAssignableFrom(toType) && toType == byte[].class) {
                FileInputStream in = null;
                ByteArrayOutputStream out = null;
                try {
                    int i = 0;
                    in = new FileInputStream((File)obj);
                    out = new ByteArrayOutputStream();
                    byte[] v = new byte[1024];
                    while ((i = in.read(v)) > 0) {
                        out.write(v, 0, i);
                    }
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            if (type.isArray() && !toType.isArray() || !type.isArray() && toType.isArray()) {
                throw new IllegalArgumentException(new StringBuffer("\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362,\u4e0d\u652f\u6301[").append(type.getName()).append("]\u5411[").append(toType.getName()).append("]\u8f6c\u6362").toString());
            }
        }
        Object arrayObj = !type.isArray() ? ValueObjectUtil.basicTypeCast(obj, type, toType) : ValueObjectUtil.arrayTypeCast(obj, type, toType);
        return arrayObj;
    }

    public static Object shell(Class toType, Object obj) {
        Interpreter interpreter = new Interpreter();
        String shell = toType.getName() + " ret = (" + toType.getName() + ")obj;return ret;";
        try {
            interpreter.set("obj", obj);
            Object ret = interpreter.eval(shell);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final Object basicTypeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException {
        SimpleDateFormat format = DataFormatUtil.getSimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (obj == null) {
            return null;
        }
        if (ValueObjectUtil.isSameType(type, toType)) {
            return obj;
        }
        if (type.isAssignableFrom(toType) && !java.util.Date.class.isAssignableFrom(type)) {
            return ValueObjectUtil.shell(toType, obj);
        }
        if (toType == Long.TYPE || toType == Long.class) {
            return new Long(obj.toString());
        }
        if (toType == Integer.TYPE || toType == Integer.class) {
            return new Integer(obj.toString());
        }
        if (toType == Float.TYPE || toType == Float.class) {
            return new Float(obj.toString());
        }
        if (toType == Short.TYPE || toType == Short.class) {
            return new Short(obj.toString());
        }
        if (toType == Double.TYPE || toType == Double.class) {
            return new Double(obj.toString());
        }
        if (toType == Character.TYPE || toType == Character.class) {
            return new Character(obj.toString().charAt(0));
        }
        if (toType == Boolean.TYPE || toType == Boolean.class) {
            return new Boolean(obj.toString());
        }
        if (toType == Byte.TYPE || toType == Byte.class) {
            return new Byte(obj.toString());
        }
        if (toType == String.class) {
            if (obj instanceof java.util.Date) {
                return format.format(obj);
            }
            return obj.toString();
        }
        if (toType == java.util.Date.class) {
            if (java.util.Date.class.isAssignableFrom(obj.getClass())) {
                return obj;
            }
            try {
                return format.parse(obj.toString());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return new java.util.Date(obj.toString());
            }
        }
        if (toType == Date.class) {
            if (java.util.Date.class.isAssignableFrom(obj.getClass())) {
                return new Date(((java.util.Date)obj).getTime());
            }
            Date date = Date.valueOf(obj.toString());
            return date;
        }
        throw new NoSupportTypeCastException(new StringBuffer("\u4e0d\u652f\u6301[").append(type).append("]\u5411[").append(toType).append("]\u7684\u8f6c\u6362").toString());
    }

    public static final Object arrayTypeCast(Object obj, Class type, Class toType) throws NoSupportTypeCastException, NumberFormatException {
        if (ValueObjectUtil.isSameType(type, toType)) {
            return obj;
        }
        if (toType == long[].class) {
            String[] values = (String[])obj;
            long[] ret = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Long.parseLong(values[i]);
            }
            return ret;
        }
        if (toType == Long[].class) {
            String[] values = (String[])obj;
            Long[] ret = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Long(values[i]);
            }
            return ret;
        }
        if (toType == int[].class) {
            String[] values = (String[])obj;
            int[] ret = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Integer.parseInt(values[i]);
            }
            return ret;
        }
        if (toType == Integer[].class) {
            String[] values = (String[])obj;
            Integer[] ret = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Integer(values[i]);
            }
            return ret;
        }
        if (toType == float[].class) {
            String[] values = (String[])obj;
            float[] ret = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Float.parseFloat(values[i]);
            }
            return ret;
        }
        if (toType == Float[].class) {
            String[] values = (String[])obj;
            Float[] ret = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Float(values[i]);
            }
            return ret;
        }
        if (toType == short[].class) {
            String[] values = (String[])obj;
            short[] ret = new short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Short.parseShort(values[i]);
            }
            return ret;
        }
        if (toType == Short[].class) {
            String[] values = (String[])obj;
            Short[] ret = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Short(values[i]);
            }
            return ret;
        }
        if (toType == double[].class) {
            String[] values = (String[])obj;
            double[] ret = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = Double.parseDouble(values[i]);
            }
            return ret;
        }
        if (toType == Double[].class) {
            String[] values = (String[])obj;
            Double[] ret = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Double(values[i]);
            }
            return ret;
        }
        if (toType == char[].class) {
            String[] values = (String[])obj;
            char[] ret = new char[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = values[i].charAt(0);
            }
            return ret;
        }
        if (toType == Character[].class) {
            String[] values = (String[])obj;
            Character[] ret = new Character[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Character(values[i].charAt(0));
            }
            return ret;
        }
        if (toType == boolean[].class) {
            String[] values = (String[])obj;
            boolean[] ret = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Boolean(values[i]);
            }
            return ret;
        }
        if (toType == Boolean[].class) {
            String[] values = (String[])obj;
            Boolean[] ret = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Boolean(values[i]);
            }
            return ret;
        }
        if (toType == byte[].class) {
            String[] values = (String[])obj;
            byte[] ret = new byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Byte(values[i]);
            }
            return ret;
        }
        if (toType == Byte[].class) {
            String[] values = (String[])obj;
            Byte[] ret = new Byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new Byte(values[i]);
            }
            return ret;
        }
        if (toType == String[].class) {
            if (obj.getClass() == java.util.Date[].class) {
                return SimpleStringUtil.dateArrayTOStringArray((Date[])obj);
            }
            String[] values = (String[])obj;
            return values;
        }
        if (toType == java.util.Date.class) {
            String[] values = (String[])obj;
            return SimpleStringUtil.stringArrayTODateArray(values, null);
        }
        if (toType == Date.class) {
            String[] values = (String[])obj;
            return SimpleStringUtil.stringArrayTOSQLDateArray(values, null);
        }
        throw new NoSupportTypeCastException(new StringBuffer("\u4e0d\u652f\u6301[").append(type).append("]\u5411[").append(toType).append("]\u7684\u8f6c\u6362").toString());
    }

    public static void getFileFromString(String value, File outfile) throws SQLException {
        byte[] bytes = value.getBytes();
        ValueObjectUtil.getFileFromBytes(bytes, outfile);
    }

    public static void getFileFromBytes(byte[] bytes, File outfile) throws SQLException {
        FileOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            out = new FileOutputStream(outfile);
            byte[] v = bytes;
            in = new ByteArrayInputStream(v);
            byte[] b = new byte[1024];
            int i = 0;
            while ((i = in.read(b)) > 0) {
                out.write(b, 0, i);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void getFileFromClob(Clob value, File outfile) throws SQLException {
        FileWriter out = null;
        Reader stream = null;
        try {
            out = new FileWriter(outfile);
            Clob clob = value;
            stream = clob.getCharacterStream();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = stream.read(buf)) > 0) {
                ((Writer)out).write(buf, 0, i);
            }
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((Writer)out).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void getFileFromBlob(Blob value, File outfile) throws SQLException {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(outfile);
            Blob blob = value;
            byte[] v = new byte[1024];
            in = blob.getBinaryStream();
            int i = 0;
            while ((i = in.read(v)) > 0) {
                out.write(v, 0, i);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new NestedSQLException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                out = null;
            }
        }
    }
}

