/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.SimpleStringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.frameworkset.util.ClassUtils;
import org.frameworkset.util.PropertiesPersister;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    private static final boolean loadFromReaderAvailable = ClassUtils.hasMethod(Properties.class, "load", Reader.class);
    private static final boolean storeToWriterAvailable = ClassUtils.hasMethod(Properties.class, "store", Writer.class, String.class);
    private static Method loadMethodfor16;
    private static Method writerMethodfor16;

    @Override
    public void load(Properties props, InputStream is) throws IOException {
        props.load(is);
    }

    @Override
    public void load(Properties props, Reader reader) throws IOException {
        if (loadFromReaderAvailable) {
            try {
                loadMethodfor16.invoke((Object)props, reader);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            this.doLoad(props, reader);
        }
    }

    protected void doLoad(Properties props, Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = SimpleStringUtil.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + SimpleStringUtil.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = SimpleStringUtil.trimTrailingWhitespace(key);
            value = SimpleStringUtil.trimLeadingWhitespace(value);
            props.put(this.unescape(key), this.unescape(value));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index = line.length() - 1; index >= 0 && line.charAt(index) == '\\'; --index) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index = 0;
        while (index < str.length()) {
            int c;
            if ((c = str.charAt(index++)) == 92) {
                if ((c = str.charAt(index++)) == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
            }
            outBuffer.append((char)c);
        }
        return outBuffer.toString();
    }

    @Override
    public void store(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
    }

    @Override
    public void store(Properties props, Writer writer, String header) throws IOException {
        if (storeToWriterAvailable) {
            try {
                writerMethodfor16.invoke((Object)props, writer, header);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            this.doStore(props, writer, header);
        }
    }

    protected void doStore(Properties props, Writer writer, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(this.escape(key, true) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int index = 0; index < len; ++index) {
            char c = str.charAt(index);
            switch (c) {
                case ' ': {
                    if (index == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                }
            }
        }
        return outBuffer.toString();
    }

    @Override
    public void loadFromXml(Properties props, InputStream is) throws IOException {
        try {
            props.loadFromXML(is);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }

    @Override
    public void storeToXml(Properties props, OutputStream os, String header) throws IOException {
        try {
            props.storeToXML(os, header);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }

    @Override
    public void storeToXml(Properties props, OutputStream os, String header, String encoding) throws IOException {
        try {
            props.storeToXML(os, header, encoding);
        }
        catch (NoSuchMethodError err) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err.getMessage());
        }
    }

    static {
        if (loadFromReaderAvailable) {
            try {
                loadMethodfor16 = Properties.class.getMethod("load", Reader.class);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            try {
                writerMethodfor16 = Properties.class.getMethod("store", Writer.class, String.class);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

