/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.ClassData;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.NoSupportTypeCastException;
import com.frameworkset.util.ValueObjectUtil;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.beans.PropertyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(TransferObjectFactory.class);
    private static HashMap classDataInfo = new HashMap();

    public static Serializable createTransferObject(Object ejb, String whichTOType, String completeTOType) {
        try {
            ClassData cData = TransferObjectFactory.getClassData(completeTOType);
            ClassData voCData = TransferObjectFactory.getClassData(whichTOType);
            Object whichTO = Class.forName(whichTOType).newInstance();
            Field[] voFields = voCData.arrFields;
            Field[] beanFields = cData.arrFields;
            if (voFields == null || voFields.length == 0 || beanFields == null || beanFields.length == 0) {
                return (Serializable)TransferObjectFactory.createTransferObject(ejb, whichTO);
            }
            block4: for (int i = 0; i < voFields.length; ++i) {
                try {
                    String voFieldName = voFields[i].getName();
                    for (int j = 0; j < beanFields.length; ++j) {
                        if (!voFieldName.equals(beanFields[j].getName())) continue;
                        voFields[i].set(whichTO, beanFields[j].get(ejb));
                        continue block4;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Serializable)whichTO;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Object createTransferObject(Map completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        ClassUtil.ClassInfo beanInfo = null;
        try {
            beanInfo = ClassUtil.getClassInfo(whichToVO.getClass());
        }
        catch (Exception e) {
            throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, "", null, null), "\u83b7\u53d6bean \u4fe1\u606f\u5931\u8d25", e);
        }
        List<ClassUtil.PropertieDescription> attributes = beanInfo.getPropertyDescriptors();
        Set keys = completeVO.entrySet();
        block6: for (Map.Entry entry : keys) {
            String name = String.valueOf(entry.getKey());
            Object pvalue = entry.getValue();
            for (ClassUtil.PropertieDescription property : attributes) {
                if (!name.equals(property.getName())) continue;
                Class type = property.getPropertyType();
                Object value = null;
                Method writeMethod = property.getWriteMethod();
                if (pvalue != null) {
                    EditorInf editor = property.getWriteMethodEditor();
                    value = editor == null ? ValueObjectUtil.typeCast(pvalue, pvalue.getClass(), type) : ValueObjectUtil.typeCast(pvalue, editor);
                }
                try {
                    writeMethod.invoke(whichToVO, value);
                    continue block6;
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
                catch (IllegalAccessException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
                catch (InvocationTargetException e) {
                    throw new PropertyAccessException(new PropertyChangeEvent(whichToVO, name, null, value), "\u8bbe\u7f6e\u5c5e\u6027\u5931\u8d25", e);
                }
            }
        }
        return whichToVO;
    }

    public static Object createTransferObject(Hashtable completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        Method[] wMethods = whichToVO.getClass().getMethods();
        if (wMethods == null || wMethods.length == 0) {
            return whichToVO;
        }
        for (int i = 0; i < wMethods.length; ++i) {
            String wmName = wMethods[i].getName();
            if (!wmName.startsWith("set")) continue;
            String wmPrex = wmName.substring(0, 3);
            String wfield = wmName.substring(3);
            Object value = null;
            try {
                Class<?> paramType;
                value = completeVO.get(wfield);
                if (value == null) {
                    log.info(new StringBuffer("warning:[").append(wfield).append(" not found in hashmap").append("]!").toString());
                    continue;
                }
                Class<?> retType = value.getClass();
                if (retType == (paramType = wMethods[i].getParameterTypes()[0])) {
                    ValueObjectUtil.invoke(whichToVO, wMethods[i], new Object[]{value});
                    continue;
                }
                Object obj = ValueObjectUtil.typeCast(value, retType, paramType);
                ValueObjectUtil.invoke(whichToVO, wMethods[i], new Object[]{obj});
                continue;
            }
            catch (NullPointerException e) {
                log.info(new StringBuffer("warning NullPointerException:[").append(wfield).append("] not found in [map]!").toString());
                continue;
            }
            catch (NoSuchMethodException e) {
                log.info(new StringBuffer("warning NoSuchMethodException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (SecurityException securitye) {
                log.info(new StringBuffer("warning SecurityException:[").append(securitye.getMessage()).append("]").toString());
                continue;
            }
            catch (NoSupportTypeCastException castException) {
                log.info(new StringBuffer("warning NoSupportTypeCastException:[").append(wfield).append("][").append(wMethods[i]).append("] return value type not match the param type!").toString());
                continue;
            }
            catch (NumberFormatException e) {
                log.info(new StringBuffer("warning NumberFormatException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                log.info(new StringBuffer("warning IllegalArgumentException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (Exception e) {
                log.info(new StringBuffer("warning Exception:[").append(e.getMessage()).append("]").toString());
            }
        }
        return whichToVO;
    }

    public static Object createTransferObject(Object completeVO, Object whichToVO) {
        if (completeVO == null || whichToVO == null) {
            return null;
        }
        Method[] wMethods = whichToVO.getClass().getMethods();
        Class<?> cClazz = completeVO.getClass();
        if (wMethods == null || wMethods.length == 0) {
            return whichToVO;
        }
        for (int i = 0; i < wMethods.length; ++i) {
            String wmName = wMethods[i].getName();
            if (!wmName.startsWith("set")) continue;
            String wmPrex = wmName.substring(0, 3);
            String wfield = wmName.substring(3);
            Method cMethod = null;
            try {
                Class<?> paramType;
                Class<?> retType;
                block20: {
                    try {
                        cMethod = cClazz.getMethod(ValueObjectUtil.getMethodName(wfield), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cMethod == null) {
                        try {
                            cMethod = cClazz.getMethod(ValueObjectUtil.getBooleanMethodName(wfield), null);
                            if (cMethod == null) {
                                log.info(new StringBuffer("warning:[").append(wMethods[i]).append("]").append(ValueObjectUtil.getMethodName(wfield)).append(" not found in [").append(cClazz).append("]!").toString());
                            }
                            break block20;
                        }
                        catch (Exception e) {
                            log.info(new StringBuffer("warning:[").append(wMethods[i]).append("]").append(ValueObjectUtil.getMethodName(wfield)).append(" not found in [").append(cClazz).append("]!").toString());
                        }
                        continue;
                    }
                }
                if ((retType = cMethod.getReturnType()) == (paramType = wMethods[i].getParameterTypes()[0])) {
                    ValueObjectUtil.invoke(whichToVO, wMethods[i], new Object[]{ValueObjectUtil.invoke(completeVO, cMethod, null)});
                    continue;
                }
                Object obj = ValueObjectUtil.typeCast(ValueObjectUtil.invoke(completeVO, cMethod, null), retType, paramType);
                ValueObjectUtil.invoke(whichToVO, wMethods[i], new Object[]{obj});
                continue;
            }
            catch (NullPointerException e) {
                log.info(new StringBuffer("warning NullPointerException:[").append(wMethods[i]).append("] not found in [").append(cClazz).append("]!").toString());
                continue;
            }
            catch (NoSuchMethodException e) {
                log.info(new StringBuffer("warning NoSuchMethodException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (SecurityException securitye) {
                log.info(new StringBuffer("warning SecurityException:[").append(securitye.getMessage()).append("]").toString());
                continue;
            }
            catch (NoSupportTypeCastException castException) {
                log.info(new StringBuffer("warning NoSupportTypeCastException:[").append(cMethod).append("][").append(wMethods[i]).append("] return value type not match the param type!" + castException.getMessage()).toString(), (Throwable)castException);
                continue;
            }
            catch (NumberFormatException e) {
                log.info(new StringBuffer("warning NumberFormatException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                log.info(new StringBuffer("warning IllegalArgumentException:[").append(e.getMessage()).append("]").toString());
                continue;
            }
            catch (Exception e) {
                log.info(new StringBuffer("warning Exception:[").append(e.getMessage()).append("]").toString());
            }
        }
        return whichToVO;
    }

    private static ClassData getClassData(String className) {
        ClassData cData = (ClassData)classDataInfo.get(className);
        try {
            if (cData == null) {
                Class<?> ejbTOClass = Class.forName(className);
                Field[] arrFields = ejbTOClass.getFields();
                cData = new ClassData(ejbTOClass, arrFields, ejbTOClass.getMethods());
                classDataInfo.put(className, cData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cData;
    }

    public static void main(String[] args) {
        log.debug("debug:aaaaa");
        log.info("info:bbbbbbb");
        log.warn("warn:bbbbbbb");
        log.error("error:bbbbbbb");
    }
}

