/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import com.frameworkset.util.EvalVariableValueFailedException;
import com.frameworkset.util.RegexUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.ClassUtil;

public class VariableHandler {
    public static String default_regex = "\\$\\{(.+?)\\}";
    static SQLStructionBuiler sqlStructionBuiler = new SQLStructionBuiler();
    static URLStructionBuiler urlStructionBuiler = new URLStructionBuiler();

    private static String buildVariableRegex(String pretoken, String endtoken) {
        StringBuffer ret = new StringBuffer();
        ret.append(pretoken).append("(.+?)").append(endtoken);
        return ret.toString();
    }

    public static String[] variableParser(String inputString) {
        String[] vars = RegexUtil.containWithPatternMatcherInput(inputString, default_regex);
        return vars;
    }

    public static String[] variableParser(String inputString, String pretoken, String endtoken) {
        return VariableHandler.variableParser(inputString, pretoken, endtoken, 16);
    }

    public static String[] variableParser(String inputString, String pretoken, String endtoken, int mask) {
        String regex = VariableHandler.buildVariableRegex(pretoken, endtoken);
        String[] vars = RegexUtil.containWithPatternMatcherInput(inputString, regex, mask);
        return vars;
    }

    public static String[] variableParser(String inputString, String regex) {
        String[] vars = RegexUtil.containWithPatternMatcherInput(inputString, regex);
        return vars;
    }

    public static String[][] parser2ndSubstitution(String inputString, String regex, String substitution) {
        return RegexUtil.contain2ndReplaceWithPatternMatcherInput(inputString, regex, substitution);
    }

    public static String[][] parser2ndSubstitution(String inputString, String substitution) {
        return RegexUtil.contain2ndReplaceWithPatternMatcherInput(inputString, default_regex, substitution);
    }

    public static String[][] parser2ndSubstitution(String inputString, String pretoken, String endtoken, String substitution) {
        String regex = VariableHandler.buildVariableRegex(pretoken, endtoken);
        return RegexUtil.contain2ndReplaceWithPatternMatcherInput(inputString, regex, substitution, 16);
    }

    public static String[][] parser2ndSubstitution(String inputString, String pretoken, String endtoken, String substitution, int mask) {
        String regex = VariableHandler.buildVariableRegex(pretoken, endtoken);
        return RegexUtil.contain2ndReplaceWithPatternMatcherInput(inputString, regex, substitution, mask);
    }

    public static String substitution(String inputString, String substitution) {
        return SimpleStringUtil.replaceAll(inputString, default_regex, substitution);
    }

    public static String substitution(String inputString, String regex, String substitution) {
        return SimpleStringUtil.replaceAll(inputString, regex, substitution);
    }

    public static URLStruction parserURLStruction(String url) {
        if (url == null || url.trim().length() == 0) {
            return null;
        }
        int len = url.length();
        int i = 0;
        StringBuffer token = new StringBuffer();
        StringBuffer var = new StringBuffer();
        boolean varstart = false;
        int varstartposition = -1;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        int varcount = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (i < len) {
            if (url.charAt(i) == '#' && i + 1 < len && url.charAt(i + 1) == '[') {
                if (varstart) {
                    token.append("#[").append(var);
                    var.setLength(0);
                }
                varstart = true;
                varstartposition = i += 2;
                var.setLength(0);
                continue;
            }
            if (varstart) {
                if (url.charAt(i) == '&') {
                    varstart = false;
                    ++i;
                    token.append("#[").append(var);
                    var.setLength(0);
                    continue;
                }
                if (url.charAt(i) == ']') {
                    if (i == varstartposition) {
                        varstart = false;
                        ++i;
                        token.append("#[]");
                        continue;
                    }
                    Variable variable = new Variable();
                    variable.setPosition(varcount);
                    variable.setVariableName(var.toString());
                    variables.add(variable);
                    tokens.add(token.toString());
                    token.setLength(0);
                    var.setLength(0);
                    ++varcount;
                    varstart = false;
                    ++i;
                    continue;
                }
                var.append(url.charAt(i));
                ++i;
                continue;
            }
            token.append(url.charAt(i));
            ++i;
        }
        if (token.length() > 0) {
            if (var.length() > 0) {
                token.append("#[").append(var);
            }
            tokens.add(token.toString());
        } else if (var.length() > 0) {
            token.append("#[").append(var);
            int idx = tokens.size() - 1;
            tokens.set(idx, (String)tokens.get(idx) + token.toString());
        }
        if (variables.size() == 0) {
            return null;
        }
        URLStruction itemUrlStruction = new URLStruction();
        itemUrlStruction.setTokens(tokens);
        itemUrlStruction.setVariables(variables);
        return itemUrlStruction;
    }

    public static URLStruction parserTempateStruction(String sql) {
        return VariableHandler._parserStruction(sql, urlStructionBuiler);
    }

    public static SQLStruction parserSQLStruction(String sql) {
        return (SQLStruction)VariableHandler._parserStruction(sql, sqlStructionBuiler);
    }

    public static URLStruction _parserStruction(String sql, StructionBuiler structionBuiler) {
        int idx;
        String partvar;
        if (sql == null || sql.trim().length() == 0) {
            return null;
        }
        int len = sql.length();
        int i = 0;
        StringBuffer token = new StringBuffer();
        StringBuffer var = new StringBuffer();
        boolean varstart = false;
        int varstartposition = -1;
        boolean index_start = false;
        Variable header = null;
        Variable hh = null;
        Variable variable = null;
        ArrayList<Index> indexs = null;
        boolean ref_start = false;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        int varcount = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (i < len) {
            if (sql.charAt(i) == '#' && i + 1 < len && sql.charAt(i + 1) == '[') {
                if (varstart) {
                    partvar = sql.substring(varstartposition, i);
                    token.append("#[").append(partvar);
                    var.setLength(0);
                }
                index_start = false;
                varstart = true;
                variable = null;
                header = null;
                header = null;
                hh = null;
                indexs = null;
                ref_start = false;
                varstartposition = i += 2;
                var.setLength(0);
                continue;
            }
            if (varstart) {
                if (sql.charAt(i) == '[') {
                    if (!ref_start) {
                        if (!index_start) {
                            header = new Variable();
                            header.setPosition(varcount);
                            header.setVariableName(var.toString());
                            var.setLength(0);
                            tokens.add(token.toString());
                            token.setLength(0);
                            ++varcount;
                            index_start = true;
                            indexs = new ArrayList();
                            header.setIndexs(indexs);
                            hh = header;
                        }
                    } else if (!index_start) {
                        variable = new Variable();
                        variable.setVariableName(var.toString());
                        var.setLength(0);
                        header.setNext(variable);
                        variable.setParent(header);
                        header = variable;
                        index_start = true;
                        indexs = new ArrayList<Index>();
                        header.setIndexs(indexs);
                    }
                    ++i;
                    var.setLength(0);
                    continue;
                }
                if (sql.charAt(i) == ']') {
                    if (i == varstartposition) {
                        varstart = false;
                        ++i;
                        token.append("#[]");
                        continue;
                    }
                    if (index_start) {
                        String t = var.toString();
                        try {
                            idx = Integer.parseInt(t);
                            indexs.add(new Index(idx));
                        }
                        catch (Exception e) {
                            indexs.add(new Index(t));
                        }
                        var.setLength(0);
                        if (i + 1 < len && sql.charAt(i + 1) == ']') {
                            index_start = false;
                            indexs = null;
                        }
                        ++i;
                        continue;
                    }
                    if (ref_start) {
                        ref_start = false;
                        varstart = false;
                        if (variable == null) {
                            variable = new Variable();
                            variable.setVariableName(var.toString());
                            var.setLength(0);
                            header.setNext(variable);
                            variable.setParent(header);
                            header = variable;
                        }
                        variables.add(hh);
                        hh = null;
                        ++i;
                        continue;
                    }
                    if (!varstart) continue;
                    if (header == null) {
                        header = new Variable();
                        header.setPosition(varcount);
                        header.setVariableName(var.toString());
                        var.setLength(0);
                        tokens.add(token.toString());
                        token.setLength(0);
                        ++varcount;
                        hh = header;
                    }
                    varstart = false;
                    variables.add(hh);
                    hh = null;
                    ++i;
                    continue;
                }
                if (sql.charAt(i) == '-') {
                    if (i + 1 >= len) continue;
                    if (sql.charAt(i + 1) == '>') {
                        if (varstart) {
                            if (!ref_start) {
                                ref_start = true;
                                if (index_start) {
                                    index_start = false;
                                    indexs = null;
                                    var.setLength(0);
                                } else if (header == null) {
                                    header = new Variable();
                                    header.setPosition(varcount);
                                    header.setVariableName(var.toString());
                                    var.setLength(0);
                                    tokens.add(token.toString());
                                    token.setLength(0);
                                    ++varcount;
                                    hh = header;
                                } else if (var.length() > 0) {
                                    variable = new Variable();
                                    variable.setVariableName(var.toString());
                                    var.setLength(0);
                                    indexs = null;
                                    header.setNext(variable);
                                    variable.setParent(header);
                                    header = variable;
                                }
                            } else if (variable == null) {
                                variable = new Variable();
                                variable.setVariableName(var.toString());
                                var.setLength(0);
                                indexs = null;
                                header.setNext(variable);
                                variable.setParent(header);
                                header = variable;
                            } else if (var.length() > 0) {
                                variable = new Variable();
                                variable.setVariableName(var.toString());
                                var.setLength(0);
                                indexs = null;
                                header.setNext(variable);
                                variable.setParent(header);
                                header = variable;
                            }
                            index_start = false;
                            indexs = null;
                        } else {
                            token.append("->");
                        }
                        ++i;
                        ++i;
                        continue;
                    }
                    var.append(sql.charAt(i));
                    ++i;
                    continue;
                }
                var.append(sql.charAt(i));
                ++i;
                continue;
            }
            token.append(sql.charAt(i));
            ++i;
        }
        if (token.length() > 0) {
            if (var.length() > 0) {
                partvar = sql.substring(varstartposition);
                token.append("#[").append(partvar);
            }
            tokens.add(token.toString());
        } else if (var.length() > 0) {
            partvar = sql.substring(varstartposition);
            token.append("#[").append(partvar);
            idx = tokens.size() - 1;
            tokens.set(idx, (String)tokens.get(idx) + token.toString());
        }
        if (variables.size() == 0) {
            return structionBuiler.buildStruction(sql);
        }
        URLStruction itemUrlStruction = structionBuiler.buildStruction();
        itemUrlStruction.setTokens(tokens);
        itemUrlStruction.setVariables(variables);
        itemUrlStruction.after();
        return itemUrlStruction;
    }

    public static Object evaluateVariableValue(Variable var, Object bean) {
        Object temp;
        block32: {
            Class<?> tcls;
            if (bean == null) {
                return null;
            }
            temp = null;
            ClassUtil.PropertieDescription pro = null;
            List<Index> indexs = null;
            indexs = var.getIndexs();
            if (indexs == null || indexs.size() == 0) {
                if (var.getNext() == null) {
                    return bean;
                }
                temp = bean;
                var = var.getNext();
            } else {
                tcls = null;
                temp = bean;
                for (Index idx : indexs) {
                    if (idx.getInt_idx() != -1) {
                        try {
                            tcls = temp.getClass();
                            if (tcls.isArray()) {
                                temp = Array.get(temp, idx.getInt_idx());
                            }
                            temp = ((List)temp).get(idx.getInt_idx());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6\u6570\u7ec4\u5143\u7d20\u5931\u8d25\uff1a\u6570\u7ec4\u8d8a\u754c" + temp + "[" + idx.getInt_idx() + "]", e);
                        }
                        catch (Throwable e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6\u6570\u7ec4\u5143\u7d20\u5931\u8d25\uff1a" + temp + "[" + idx.getInt_idx() + "]", e);
                        }
                    } else {
                        try {
                            temp = ((Map)temp).get(idx.getString_idx());
                        }
                        catch (Throwable e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6Map\u5143\u7d20\u5931\u8d25\uff1a" + temp + "[" + idx.getString_idx() + "]", e);
                        }
                    }
                    if (temp != null) continue;
                    break;
                }
                if (var.getNext() == null) {
                    return temp;
                }
                var = var.getNext();
            }
            do {
                if (!(temp instanceof Map)) {
                    pro = ClassUtil.getPropertyDescriptor(temp.getClass(), var.getVariableName());
                    if (pro == null) {
                        throw new EvalVariableValueFailedException("\u8ba1\u7b97\u53d8\u91cf\u503c\u5931\u8d25\uff1aclass[" + bean.getClass().getCanonicalName() + "]\u6ca1\u6709\u5b9a\u4e49\u5c5e\u6027[" + var.getVariableName() + "]");
                    }
                    try {
                        temp = pro.getValue(temp);
                    }
                    catch (EvalVariableValueFailedException e) {
                        throw e;
                    }
                    catch (IllegalAccessException e) {
                        throw new EvalVariableValueFailedException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new EvalVariableValueFailedException(e.getTargetException());
                    }
                    catch (Throwable e) {
                        throw new EvalVariableValueFailedException(e);
                    }
                } else {
                    temp = ((Map)temp).get(var.getVariableName());
                }
                if (temp == null) break;
                indexs = var.getIndexs();
                if (indexs == null || indexs.size() <= 0) continue;
                tcls = null;
                for (Index idx : indexs) {
                    if (idx.getInt_idx() != -1) {
                        try {
                            tcls = temp.getClass();
                            if (tcls.isArray()) {
                                temp = Array.get(temp, idx.getInt_idx());
                            }
                            temp = ((List)temp).get(idx.getInt_idx());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6\u6570\u7ec4\u5143\u7d20\u5931\u8d25\uff1a\u6570\u7ec4\u8d8a\u754c" + temp + "[" + idx.getInt_idx() + "]", e);
                        }
                        catch (Throwable e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6\u6570\u7ec4\u5143\u7d20\u5931\u8d25\uff1a" + temp + "[" + idx.getInt_idx() + "]", e);
                        }
                    } else {
                        try {
                            temp = ((Map)temp).get(idx.getString_idx());
                        }
                        catch (Throwable e) {
                            throw new EvalVariableValueFailedException("\u83b7\u53d6Map\u5143\u7d20\u5931\u8d25\uff1a" + temp + "[" + idx.getString_idx() + "]", e);
                        }
                    }
                    if (temp != null) continue;
                    break block32;
                }
            } while ((var = var.getNext()) != null);
        }
        return temp;
    }

    static class URLStructionBuiler
    implements StructionBuiler {
        URLStructionBuiler() {
        }

        @Override
        public URLStruction buildStruction() {
            return new URLStruction();
        }

        @Override
        public URLStruction buildStruction(String token) {
            return new URLStruction(token);
        }
    }

    static class SQLStructionBuiler
    implements StructionBuiler {
        SQLStructionBuiler() {
        }

        @Override
        public URLStruction buildStruction() {
            return new SQLStruction();
        }

        @Override
        public URLStruction buildStruction(String token) {
            return new SQLStruction(token);
        }
    }

    static interface StructionBuiler {
        public URLStruction buildStruction();

        public URLStruction buildStruction(String var1);
    }

    public static class Index {
        private int int_idx = -1;
        private String string_idx;

        public Index(int index) {
            this.int_idx = index;
        }

        public Index(String index) {
            this.string_idx = index;
        }

        public int getInt_idx() {
            return this.int_idx;
        }

        public String getString_idx() {
            return this.string_idx;
        }

        public String toString() {
            if (this.int_idx != -1) {
                return this.int_idx + "";
            }
            return this.string_idx;
        }
    }

    public static class Variable {
        private String variableName;
        private int position;
        private List<Index> indexs;
        private Variable parent;
        private Variable next;

        public String getVariableName() {
            return this.variableName;
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public List<Index> getIndexs() {
            return this.indexs;
        }

        public void setIndexs(List<Index> indexs) {
            this.indexs = indexs;
        }

        public Variable getParent() {
            return this.parent;
        }

        public void setParent(Variable parent) {
            this.parent = parent;
        }

        public Variable getNext() {
            return this.next;
        }

        public void setNext(Variable next) {
            this.next = next;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.variableName);
            if (this.indexs != null && this.indexs.size() > 0) {
                for (Index idx : this.indexs) {
                    ret.append("[").append(idx.toString()).append("]");
                }
            }
            if (this.next != null) {
                ret.append("->").append(this.next.toString());
            }
            if (this.parent == null) {
                ret.append(",position=").append(this.position);
            }
            return ret.toString();
        }
    }

    public static class SQLStruction
    extends URLStruction {
        private String sql;

        public SQLStruction() {
        }

        public SQLStruction(String sql) {
            this.sql = sql;
        }

        @Override
        protected void after() {
            super.after();
            this.buildSQL();
        }

        public String buildSQL() {
            if (this.sql == null && this.variables != null && this.variables.size() > 0) {
                int vsize;
                StringBuffer sql_ = new StringBuffer();
                int tsize = this.tokens.size();
                if (tsize == (vsize = this.variables.size())) {
                    for (int i = 0; i < vsize; ++i) {
                        sql_.append((String)this.tokens.get(i)).append("?");
                    }
                } else {
                    for (int i = 0; i < vsize; ++i) {
                        sql_.append((String)this.tokens.get(i)).append("?");
                    }
                    sql_.append((String)this.tokens.get(vsize));
                }
                this.sql = sql_.toString();
            }
            return this.sql;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }
    }

    public static class URLStruction {
        protected List<String> tokens;
        protected List<Variable> variables;
        protected boolean hasVars;
        protected String url;

        public URLStruction() {
        }

        public URLStruction(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean hasVars() {
            return this.hasVars;
        }

        protected void after() {
            if (this.variables != null && this.variables.size() >= 0) {
                this.hasVars = true;
            }
        }

        public List<String> getTokens() {
            return this.tokens;
        }

        public void setTokens(List<String> tokens) {
            this.tokens = tokens;
        }

        public List<Variable> getVariables() {
            return this.variables;
        }

        public void setVariables(List<Variable> variables) {
            this.variables = variables;
        }
    }
}

