/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.util;

import bboss.org.apache.velocity.Template;
import bboss.org.apache.velocity.VelocityContext;
import bboss.org.apache.velocity.app.Velocity;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.runtime.resource.Resource;
import com.frameworkset.util.FileUtil;
import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityUtil {
    private static Logger log = LoggerFactory.getLogger(VelocityUtil.class);
    private static boolean inited = false;
    private static boolean VERSION_OLD = true;
    private static Object lock = new Object();

    public static boolean OLDVERSION() {
        VelocityUtil.init(null);
        return VERSION_OLD;
    }

    private static File computeApplicationDir(URL location, File defaultDir) {
        if (location == null) {
            System.out.println("Warning: Cannot locate the program directory. Assuming default.");
            return defaultDir;
        }
        if (!"file".equalsIgnoreCase(location.getProtocol())) {
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(".");
        }
        String file = location.getFile();
        if (!file.endsWith(".jar") && !file.endsWith(".zip")) {
            try {
                return new File(URLDecoder.decode(location.getFile(), "UTF-8")).getParentFile().getParentFile();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println("Warning: Unrecognized location type. Assuming default.");
                return new File(location.getFile());
            }
        }
        try {
            File path = null;
            path = !VelocityUtil.isLinux() ? new File(URLDecoder.decode(location.toExternalForm().substring(6), "UTF-8")).getParentFile().getParentFile() : new File(URLDecoder.decode(location.toExternalForm().substring(5), "UTF-8")).getParentFile().getParentFile();
            return path;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("Warning: Unrecognized location type. Assuming default.");
            return new File(location.getFile());
        }
    }

    public static final String getOS() {
        return System.getProperty("os.name");
    }

    public static final boolean isWindows() {
        return VelocityUtil.getOS().startsWith("Windows");
    }

    public static final boolean isLinux() {
        return VelocityUtil.getOS().startsWith("Linux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String approot) {
        if (inited) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (inited) {
                return;
            }
            try {
                String approot_;
                Properties aop;
                String templatePath;
                File templatePathFile;
                if (approot == null) {
                    String approot_2;
                    Properties aop2 = SimpleStringUtil.getProperties("/aop.properties", VelocityUtil.class);
                    if (aop2 != null && (approot_2 = aop2.getProperty("approot")) != null && !approot_2.equals("")) {
                        approot = approot_2;
                    }
                } else {
                    String approot_3;
                    Properties aop3;
                    File f = new File(approot);
                    if (!f.exists() && (aop3 = SimpleStringUtil.getProperties("/aop.properties", VelocityUtil.class)) != null && (approot_3 = aop3.getProperty("approot")) != null && !approot_3.equals("")) {
                        approot = approot_3;
                    }
                }
                String appDir = FileUtil.apppath + "/WEB-INF";
                log.debug("FileUtil.apppath:" + FileUtil.apppath);
                if (approot != null && !new File(appDir).exists()) {
                    appDir = approot + "/WEB-INF";
                }
                if (!(templatePathFile = new File(templatePath = appDir + "/templates")).exists() && (aop = SimpleStringUtil.getProperties("/aop.properties", VelocityUtil.class)) != null && (approot_ = aop.getProperty("approot")) != null && !approot_.equals("")) {
                    templatePath = SimpleStringUtil.getRealPath(approot_, "/WEB-INF/templates");
                }
                log.debug("velocity.properties:" + VelocityUtil.class.getResource("/bboss-velocity.properties"));
                Properties pros = SimpleStringUtil.getProperties("/bboss-velocity.properties", VelocityUtil.class);
                String loadclass = (String)pros.get("file.resource.loader.class");
                if (loadclass != null && loadclass.equals("bboss.org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader")) {
                    VERSION_OLD = false;
                } else {
                    pros.setProperty("file.resource.loader.path", templatePath);
                }
                try {
                    Velocity.init((Properties)pros);
                    inited = true;
                }
                catch (Throwable ex) {
                    try {
                        log.error("Init velocity failed from bboss-velocity.properties\uff1a" + ex.getMessage(), ex);
                        Velocity.init((String)"velocity.properties");
                        inited = true;
                    }
                    catch (Exception e) {
                        inited = true;
                        log.error("Init velocity failed:velocity.properties (\u7cfb\u7edf\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6\u3002) \u68c0\u67e5classpath\u4e2d\u662f\u5426\u914d\u7f6e\u6b63\u786e:" + ex.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                inited = true;
                log.error("Init velocity failed:velocity.properties (\u7cfb\u7edf\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6\u3002) \u68c0\u67e5classpath\u4e2d\u662f\u5426\u914d\u7f6e\u6b63\u786e:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Template getTemplate(String templateName) {
        if (SimpleStringUtil.isEmpty(templateName)) {
            return null;
        }
        VelocityUtil.init(null);
        Template template = null;
        try {
            if (!VERSION_OLD && !templateName.startsWith("templates/")) {
                templateName = "templates/" + templateName;
            }
            template = Velocity.getTemplate((String)templateName);
        }
        catch (ResourceNotFoundException rnfe) {
            log.error("Cannot find template " + templateName + ": new version have change template dir as classpath root relatived,but not web-inf dir,please copy templates in web-inf to classpath root dir.", (Throwable)rnfe);
        }
        catch (ParseErrorException pee) {
            log.error("Syntax error in template " + templateName + ":", (Throwable)pee);
        }
        catch (Exception ex) {
            log.error("Error in Template " + templateName + ":", (Throwable)ex);
        }
        return template;
    }

    public static String evaluate(VelocityContext context, String templateName, String template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (String)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return template;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return template;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return template;
        }
        catch (Exception e) {
            e.printStackTrace();
            return template;
        }
        return out.toString();
    }

    public static void evaluate(VelocityContext context, Writer out, String templateName, String template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (String)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String evaluate(VelocityContext context, String templateName, InputStream template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (InputStream)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return null;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return out.toString();
    }

    public static void evaluate(VelocityContext context, Writer out, String templateName, InputStream template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (InputStream)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String evaluate(VelocityContext context, String templateName, Reader template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (Reader)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return null;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return out.toString();
    }

    public static void evaluate(VelocityContext context, Writer out, String templateName, Reader template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)context, (Writer)out, (String)templateName, (Reader)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static VelocityContext buildVelocityContext(Map<String, Object> context) {
        VelocityContext context_ = new VelocityContext();
        if (context != null && context.size() > 0) {
            for (String key : context.keySet()) {
                context_.put(key, context.get(key));
            }
        }
        return context_;
    }

    public static String evaluate(Map context, String templateName, String template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (String)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return template;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return template;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return template;
        }
        catch (Exception e) {
            e.printStackTrace();
            return template;
        }
        return out.toString();
    }

    public static void evaluate(Map context, Writer out, String templateName, String template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (String)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String evaluate(Map context, String templateName, InputStream template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (InputStream)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return null;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return out.toString();
    }

    public static void evaluate(Map context, Writer out, String templateName, InputStream template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (InputStream)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String evaluate(Map context, String templateName, Reader template) {
        VelocityUtil.init(null);
        StringWriter out = new StringWriter();
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (Reader)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
            return null;
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return out.toString();
    }

    public static void evaluate(Map context, Writer out, String templateName, Reader template) {
        VelocityUtil.init(null);
        try {
            Velocity.evaluate((Context)VelocityUtil.buildVelocityContext(context), (Writer)out, (String)templateName, (Reader)template);
        }
        catch (ParseErrorException e) {
            e.printStackTrace();
        }
        catch (MethodInvocationException e) {
            e.printStackTrace();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initTemplate(Resource template) {
        VelocityUtil.init(null);
        Velocity.initTemplate((Resource)template);
    }

    public static void initTemplate(Resource template, String encoding) {
        VelocityUtil.init(null);
        Velocity.initTemplate((Resource)template, (String)encoding);
    }

    public static void main(String[] args) {
        VelocityUtil velocityutil = new VelocityUtil();
        VelocityContext fcontext = new VelocityContext();
    }
}

