/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import org.frameworkset.json.JacksonObjectMapper;
import org.frameworkset.json.JsonTypeReference;

public class Jackson2ObjectMapper
implements JacksonObjectMapper {
    protected ObjectMapper mapper = new ObjectMapper();

    public Jackson2ObjectMapper() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public <T> T json2Object(String jsonString, Class<T> toclass) {
        return this.json2Object(jsonString, toclass, true);
    }

    @Override
    public <T> T json2Object(String jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        try {
            Object value = this.mapper.readValue(jsonString, toclass);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(jsonString, e);
        }
    }

    @Override
    public <T> T json2Object(InputStream jsonString, Class<T> toclass, boolean ALLOW_SINGLE_QUOTES) {
        try {
            Object value = this.mapper.readValue(jsonString, toclass);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("", e);
        }
    }

    @Override
    public <T> T json2ObjectWithType(InputStream jsonString, final JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Object> ref_ = new TypeReference<Object>(){

            public Type getType() {
                return ref.getType();
            }
        };
        try {
            Object value = mapper.readValue(jsonString, (TypeReference)ref_);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> T json2ObjectWithType(String jsonString, final JsonTypeReference<T> ref, boolean ALLOW_SINGLE_QUOTES) {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Object> ref_ = new TypeReference<Object>(){

            public Type getType() {
                return ref.getType();
            }
        };
        try {
            Object value = mapper.readValue(jsonString, (TypeReference)ref_);
            return (T)value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(jsonString, e);
        }
    }

    @Override
    public String object2json(Object object) {
        return this.object2json(object, true);
    }

    @Override
    public String object2json(Object object, boolean ALLOW_SINGLE_QUOTES) {
        try {
            String value = this.mapper.writeValueAsString(object);
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, File writer) {
        this.object2json(object, writer, true);
    }

    @Override
    public void object2json(Object object, File writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            this.mapper.writeValue(writer, object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, OutputStream writer) {
        this.object2json(object, writer, true);
    }

    @Override
    public void object2json(Object object, OutputStream writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            this.mapper.writeValue(writer, object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public void object2json(Object object, Writer writer) {
        this.object2json(object, writer, true);
    }

    @Override
    public void object2json(Object object, Writer writer, boolean ALLOW_SINGLE_QUOTES) {
        try {
            this.mapper.writeValue(writer, object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }

    @Override
    public byte[] object2jsonAsbyte(Object object) {
        return this.object2jsonAsbyte(object, true);
    }

    @Override
    public byte[] object2jsonAsbyte(Object object, boolean ALLOW_SINGLE_QUOTES) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u9519\u8bef\u7684json\u5e8f\u5217\u5316\u64cd\u4f5c", e);
        }
    }
}

