/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.frameworkset.util.AntPathMatcher;
import org.frameworkset.util.Assert;
import org.frameworkset.util.BridgeMethodResolver;
import org.frameworkset.util.PathMatcher;
import org.frameworkset.util.annotations.MethodInfo;
import org.frameworkset.util.annotations.PathVariableInfo;

public abstract class AnnotationUtils {
    static final String VALUE = "value";
    static final PathMatcher pathmatcher = new AntPathMatcher();

    public static Annotation[] getAnnotations(Method method) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotations();
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        return BridgeMethodResolver.findBridgedMethod(method).getAnnotation(annotationType);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        while (annotation == null && (cl = cl.getSuperclass()) != null && cl != Object.class) {
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return annotation;
    }

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Assert.notNull(clazz, "Class must not be null");
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static Class<?> findAnnotationDeclaringClass(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        return AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz) ? clazz : AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz.getSuperclass());
    }

    public static boolean isAnnotationDeclaredLocally(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        boolean declaredLocally = false;
        for (Annotation annotation : Arrays.asList(clazz.getDeclaredAnnotations())) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            declaredLocally = true;
            break;
        }
        return declaredLocally;
    }

    public static boolean isAnnotationInherited(Class<? extends Annotation> annotationType, Class<?> clazz) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        Assert.notNull(clazz, "Class must not be null");
        return clazz.isAnnotationPresent(annotationType) && !AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz);
    }

    public static Map<String, Object> getAnnotationAttributes(Annotation annotation) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method method = methods[j];
            if (method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            try {
                attrs.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
                continue;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not obtain annotation attribute values", ex);
            }
        }
        return attrs;
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getDefaultValue(Annotation annotation) {
        return AnnotationUtils.getDefaultValue(annotation, VALUE);
    }

    public static Object getDefaultValue(Annotation annotation, String attributeName) {
        return AnnotationUtils.getDefaultValue(annotation.annotationType(), attributeName);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getDefaultValue(annotationType, VALUE);
    }

    public static Object getDefaultValue(Class<? extends Annotation> annotationType, String attributeName) {
        try {
            Method method = annotationType.getDeclaredMethod(attributeName, new Class[0]);
            return method.getDefaultValue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> parserPathdata(String path) {
        if (path.startsWith("//")) {
            path = path.substring(2);
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> datas = new ArrayList<String>();
        int i = 0;
        char c = ' ';
        int end = path.length();
        StringBuilder bu = new StringBuilder();
        do {
            if ((c = (char)path.charAt(i)) == '/') {
                datas.add(bu.toString());
                bu.setLength(0);
                if (i != end - 1) continue;
                datas.add("");
                continue;
            }
            bu.append(c);
        } while (++i < end);
        if (bu.length() > 0) {
            datas.add(bu.toString());
            bu = null;
        }
        return datas;
    }

    public static Map resolvePathDatas(MethodInfo method, String lookupPath) {
        if (lookupPath == null || lookupPath.length() == 0) {
            return null;
        }
        PathVariableInfo[] variables = method.getPathVariables();
        if (variables == null || variables.length == 0) {
            return null;
        }
        List<String> datas = AnnotationUtils.parserPathdata(lookupPath);
        HashMap<String, String> retdatas = new HashMap<String, String>();
        for (int i = 0; i < variables.length; ++i) {
            PathVariableInfo variable = variables[i];
            int pos = variable.getPostion();
            String key = variable.getVariable();
            String value = datas.get(pos);
            if (variable.getConstantstr() == null) {
                retdatas.put(key, value);
                continue;
            }
            if (value.endsWith(variable.getConstantstr())) {
                retdatas.put(key, value.substring(0, value.length() - variable.getConstantstr().length()));
                continue;
            }
            retdatas.put(key, value);
        }
        return retdatas;
    }

    public static String converDefaultValue(String defaultValue) {
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue)) {
            return null;
        }
        return defaultValue;
    }
}

