/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations.wraper;

import com.frameworkset.orm.annotation.Column;
import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.SimpleStringUtil;
import java.util.Locale;
import org.frameworkset.util.annotations.AnnotationUtils;
import org.frameworkset.util.annotations.DateFormateMeta;

public class ColumnWraper {
    private String dataformat;
    private String name;
    private String type;
    private String charset;
    private String editor;
    private String editorparams;
    private ColumnEditorInf _editor;
    private boolean inited;
    private boolean ignoreCUDbind = false;
    private boolean ignorebind = false;
    private Locale locale;
    private DateFormateMeta dateFormateMeta;

    public ColumnWraper(Column column) {
        this.dataformat = AnnotationUtils.converDefaultValue(column.dataformat());
        this.editorparams = AnnotationUtils.converDefaultValue(column.editorparams());
        this.name = column.name();
        this.type = AnnotationUtils.converDefaultValue(column.type());
        this.charset = AnnotationUtils.converDefaultValue(column.charset());
        this.editor = AnnotationUtils.converDefaultValue(column.editor());
        this.ignoreCUDbind = column.ignoreCUDbind();
        this.ignorebind = column.ignorebind();
        if (SimpleStringUtil.isNotEmpty(this.dataformat)) {
            this.dateFormateMeta = new DateFormateMeta();
            if (SimpleStringUtil.isNotEmpty(column.locale())) {
                try {
                    this.locale = new Locale(column.locale());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.dateFormateMeta.setLocale(this.locale);
                this.dateFormateMeta.setLocale_str(column.locale());
            }
            this.dateFormateMeta.setDateformat(this.dataformat);
        }
    }

    public String dataformat() {
        return this.dataformat;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String charset() {
        return this.charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnEditorInf editor() {
        if (this.inited) {
            return this._editor;
        }
        ColumnWraper columnWraper = this;
        synchronized (columnWraper) {
            if (this.inited) {
                return this._editor;
            }
            if (this.editor != null && !this.editor.trim().equals("")) {
                try {
                    Class<?> clazz = Class.forName(this.editor.trim());
                    this._editor = (ColumnEditorInf)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.inited = true;
        }
        return this._editor;
    }

    public String editorparams() {
        return this.editorparams;
    }

    public boolean ignoreCUDbind() {
        return this.ignoreCUDbind;
    }

    public boolean ignorebind() {
        return this.ignorebind;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateFormateMeta getDateFormateMeta() {
        return this.dateFormateMeta;
    }
}

