/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.annotations.wraper;

import com.frameworkset.util.SimpleStringUtil;
import java.util.Locale;
import org.frameworkset.util.annotations.AnnotationUtils;
import org.frameworkset.util.annotations.CookieValue;

public class CookieValueWraper {
    private Locale locale;
    private String name;
    private boolean required;
    private String editor;
    private String defaultvalue;
    private String dateformat;

    public CookieValueWraper(CookieValue cookieValue) {
        this.name = cookieValue.name();
        this.required = cookieValue.required();
        this.editor = cookieValue.editor();
        this.defaultvalue = AnnotationUtils.converDefaultValue(cookieValue.defaultvalue());
        this.dateformat = AnnotationUtils.converDefaultValue(cookieValue.dateformat());
        if (SimpleStringUtil.isNotEmpty(cookieValue.locale())) {
            try {
                this.locale = new Locale(cookieValue.locale());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String name() {
        return this.name;
    }

    public boolean required() {
        return this.required;
    }

    public String editor() {
        return this.editor;
    }

    public String defaultvalue() {
        return this.defaultvalue;
    }

    public String dateformat() {
        return this.dateformat;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

