/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.frameworkset.util.ResourceUtils;
import org.frameworkset.util.io.NestedIOException;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourceHandleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource
implements Resource {
    protected volatile long savesize;
    private static Logger log = LoggerFactory.getLogger(AbstractResource.class);

    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException ex) {
            try {
                InputStream is = this.getInputStream();
                is.close();
                return true;
            }
            catch (Throwable isEx) {
                log.error("", isEx);
                return false;
            }
        }
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException ex) {
            throw new NestedIOException("Invalid URI [" + url + "]", ex);
        }
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    @Override
    public long lastModified() throws IOException {
        long lastModified = this.getFileForLastModifiedCheck().lastModified();
        if (lastModified == 0L) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for resolving its last-modified timestamp");
        }
        return lastModified;
    }

    @Override
    public long contentLength() throws IOException {
        return this.getFile().length();
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    public String getFilename() throws IllegalStateException {
        throw new IllegalStateException(this.getDescription() + " does not carry a filename");
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.getDescription().hashCode();
    }

    @Override
    public void release() {
    }

    public void savetofile(File destinctionFile, ResourceHandleListener<AbstractResource> listener) throws IOException {
        InputStream stFileInputStream = null;
        FileOutputStream stFileOutputStream = null;
        OutputStream dufferOput = null;
        try {
            int bytesRead;
            if (listener != null) {
                try {
                    listener.startEvent(this, destinctionFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((stFileInputStream = this.getInputStream()) == null) {
                return;
            }
            stFileOutputStream = new FileOutputStream(destinctionFile);
            dufferOput = new BufferedOutputStream(stFileOutputStream);
            int arraySize = 1024;
            byte[] buffer = new byte[arraySize];
            while ((bytesRead = stFileInputStream.read(buffer)) != -1) {
                dufferOput.write(buffer, 0, bytesRead);
                this.savesize += (long)bytesRead;
                if (listener == null) continue;
                try {
                    listener.handleDataEvent(this, destinctionFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dufferOput.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (listener != null) {
                try {
                    listener.endEvent(this, destinctionFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (stFileInputStream != null) {
                try {
                    stFileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dufferOput != null) {
                try {
                    dufferOput.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (stFileOutputStream != null) {
                try {
                    stFileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void savetofile(File destinctionFile) throws IOException {
        this.savetofile(destinctionFile, null);
    }

    public long getSavesize() {
        return this.savesize;
    }
}

