/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.tokenizer;

import java.util.ArrayList;
import java.util.List;

public class TextGrammarParser {
    private static boolean tplstart(char value, char[] pre, String text, int textsize, int curpos) {
        boolean tplstart = true;
        int k = 0;
        for (int i = 1; i < pre.length; ++i) {
            k = curpos + i;
            if (k < textsize && text.charAt(k) == pre[i]) continue;
            tplstart = false;
            break;
        }
        return tplstart;
    }

    public static List<GrammarToken> parser(String content, String tokenpre, char tokenend) {
        StringBuilder builder = new StringBuilder();
        StringBuilder tplbuilder = new StringBuilder();
        ArrayList<GrammarToken> tokens = new ArrayList<GrammarToken>();
        int size = content.length();
        char[] pre = tokenpre.toCharArray();
        boolean tplstart = false;
        for (int i = 0; i < size; ++i) {
            char c = content.charAt(i);
            if (c == pre[0]) {
                if (TextGrammarParser.tplstart(c, pre, content, size, i)) {
                    if (tplstart) {
                        builder.append(tokenpre).append(tplbuilder.toString());
                        tplbuilder.setLength(0);
                    } else {
                        tplstart = true;
                    }
                    i = i + pre.length - 1;
                    continue;
                }
                if (tplstart) {
                    tplbuilder.append(c);
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == tokenend) {
                if (tplstart) {
                    if (tplbuilder.length() > 0) {
                        GrammarToken stringtoken;
                        if (builder.length() > 0) {
                            stringtoken = new GrammarToken();
                            stringtoken.position = tokens.size();
                            stringtoken.text = builder.toString();
                            stringtoken.type = 0;
                            builder.setLength(0);
                            tokens.add(stringtoken);
                        }
                        stringtoken = new GrammarToken();
                        stringtoken.position = tokens.size();
                        String txt = tplbuilder.toString();
                        int pos = txt.indexOf(":");
                        String defaultValue = null;
                        if (pos > 0) {
                            defaultValue = txt.substring(pos + 1);
                            txt = txt.substring(0, pos);
                            stringtoken.setDefaultValue(defaultValue);
                        }
                        stringtoken.text = txt;
                        stringtoken.type = 1;
                        tplbuilder.setLength(0);
                        tokens.add(stringtoken);
                    } else {
                        builder.append(tokenpre).append(tokenend);
                    }
                    tplstart = false;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (tplstart) {
                tplbuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        if (tplbuilder.length() > 0) {
            builder.append(tokenpre).append(tplbuilder.toString());
        }
        tplbuilder = null;
        if (builder.length() > 0) {
            GrammarToken stringtoken = new GrammarToken();
            stringtoken.position = tokens.size();
            stringtoken.text = builder.toString();
            stringtoken.type = 0;
            builder.setLength(0);
            tokens.add(stringtoken);
        }
        builder = null;
        return tokens;
    }

    public static class GrammarToken {
        public static final int TextPlain = 0;
        public static final int VARIABLE = 1;
        private int position;
        private String text;
        private String defaultValue;
        private int type;

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("text=").append(this.text).append("|");
            builder.append("position=").append(this.position).append("|");
            builder.append("type=").append(this.type == 0 ? "\u666e\u901a\u6587\u672c" : "\u7ed3\u6784\u53d8\u91cf").append("\r\n");
            return builder.toString();
        }

        public boolean texttoken() {
            return this.type == 0;
        }

        public boolean varibletoken() {
            return this.type == 1;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

