/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.util.introspection;

import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.util.RuntimeServicesAware;
import bboss.org.apache.velocity.util.introspection.Info;
import bboss.org.apache.velocity.util.introspection.SecureIntrospectorControl;
import bboss.org.apache.velocity.util.introspection.SecureIntrospectorImpl;
import bboss.org.apache.velocity.util.introspection.UberspectImpl;
import java.util.Iterator;

public class SecureUberspector
extends UberspectImpl
implements RuntimeServicesAware {
    RuntimeServices runtimeServices;

    @Override
    public void init() {
        String[] badPackages = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.packages");
        String[] badClasses = this.runtimeServices.getConfiguration().getStringArray("introspector.restrict.classes");
        this.introspector = new SecureIntrospectorImpl(badClasses, badPackages, this.log);
    }

    @Override
    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj != null) {
            SecureIntrospectorControl sic = (SecureIntrospectorControl)((Object)this.introspector);
            if (sic.checkObjectExecutePermission(obj.getClass(), null)) {
                return super.getIterator(obj, i);
            }
            this.log.warn("Cannot retrieve iterator from " + obj.getClass() + " due to security restrictions.");
        }
        return null;
    }

    @Override
    public void setRuntimeServices(RuntimeServices rs) {
        this.runtimeServices = rs;
    }
}

