/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.element;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.element.Element;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class OnElement
implements Element {
    private final String fullKeyspace;
    private final Expression expression;
    private final Expression[] additionalExpressions;

    public OnElement(String namespace, String keyspace, Expression expression, Expression[] additionalExpressions) {
        this.fullKeyspace = namespace == null ? "`" + keyspace + "`" : "`" + namespace + "`:`" + keyspace + "`";
        this.expression = expression;
        this.additionalExpressions = additionalExpressions;
    }

    @Override
    public String export() {
        if (this.expression == null) {
            return "ON " + this.fullKeyspace;
        }
        if (this.additionalExpressions == null || this.additionalExpressions.length == 0) {
            return "ON " + this.fullKeyspace + "(" + this.expression.toString() + ")";
        }
        StringBuilder on = new StringBuilder("ON ");
        on.append(this.fullKeyspace).append('(').append(this.expression);
        for (Expression additionalExpression : this.additionalExpressions) {
            on.append(", ").append(additionalExpression.toString());
        }
        on.append(')');
        return on.toString();
    }
}

