/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository.mapping;

import com.couchbase.client.java.repository.annotation.EncryptedField;
import com.couchbase.client.java.repository.annotation.Field;
import com.couchbase.client.java.repository.annotation.Id;
import com.couchbase.client.java.repository.mapping.PropertyMetadata;
import com.couchbase.client.java.repository.mapping.RepositoryMappingException;

public class ReflectionBasedPropertyMetadata
implements PropertyMetadata {
    private final java.lang.reflect.Field fieldReference;
    private final boolean isId;
    private final boolean isField;
    private final String name;
    private final String realName;
    private String encryptionProviderName;

    public ReflectionBasedPropertyMetadata(java.lang.reflect.Field fieldReference) {
        this.fieldReference = fieldReference;
        this.isId = fieldReference.isAnnotationPresent(Id.class);
        this.isField = fieldReference.isAnnotationPresent(Field.class);
        if (fieldReference.isAnnotationPresent(EncryptedField.class)) {
            EncryptedField encryptedField = fieldReference.getAnnotation(EncryptedField.class);
            this.encryptionProviderName = encryptedField.provider();
        }
        this.realName = fieldReference.getName();
        this.name = ReflectionBasedPropertyMetadata.extractName(fieldReference);
        fieldReference.setAccessible(true);
    }

    @Override
    public boolean isId() {
        return this.isId;
    }

    @Override
    public boolean isField() {
        return this.isField;
    }

    @Override
    public String encryptionProviderName() {
        return this.encryptionProviderName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String realName() {
        return this.realName;
    }

    @Override
    public Class<?> type() {
        return this.fieldReference.getType();
    }

    @Override
    public Object get(Object source) {
        try {
            return this.fieldReference.get(source);
        }
        catch (IllegalAccessException ex) {
            throw new RepositoryMappingException("Could not access field.", ex);
        }
    }

    @Override
    public void set(Object value, Object source) {
        try {
            this.fieldReference.set(source, value);
        }
        catch (IllegalAccessException ex) {
            throw new RepositoryMappingException("Could not access field.", ex);
        }
    }

    private static String extractName(java.lang.reflect.Field fieldReference) {
        Field annotation = fieldReference.getAnnotation(Field.class);
        if (annotation == null || annotation.value() == null || annotation.value().isEmpty()) {
            return fieldReference.getName();
        }
        return annotation.value();
    }
}

