/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import com.couchbase.client.java.search.queries.ConjunctionQuery;
import com.couchbase.client.java.search.queries.DisjunctionQuery;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class BooleanQuery
extends AbstractFtsQuery {
    private final ConjunctionQuery must = new ConjunctionQuery(new AbstractFtsQuery[0]);
    private final DisjunctionQuery mustNot;
    private final DisjunctionQuery should = new DisjunctionQuery(new AbstractFtsQuery[0]);

    public BooleanQuery() {
        this.mustNot = new DisjunctionQuery(new AbstractFtsQuery[0]);
    }

    public BooleanQuery shouldMin(int minForShould) {
        this.should.min(minForShould);
        return this;
    }

    public BooleanQuery must(AbstractFtsQuery ... mustQueries) {
        this.must.and(mustQueries);
        return this;
    }

    public BooleanQuery mustNot(AbstractFtsQuery ... mustNotQueries) {
        this.mustNot.or(mustNotQueries);
        return this;
    }

    public BooleanQuery should(AbstractFtsQuery ... shouldQueries) {
        this.should.or(shouldQueries);
        return this;
    }

    @Override
    public BooleanQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        boolean shouldIsEmpty;
        boolean mustIsEmpty = this.must == null || this.must.childQueries().isEmpty();
        boolean mustNotIsEmpty = this.mustNot == null || this.mustNot.childQueries().isEmpty();
        boolean bl = shouldIsEmpty = this.should == null || this.should.childQueries().isEmpty();
        if (mustIsEmpty && mustNotIsEmpty && shouldIsEmpty) {
            throw new IllegalArgumentException("Boolean query needs at least one of must, mustNot and should");
        }
        if (!mustIsEmpty) {
            JsonObject jsonMust = JsonObject.create();
            this.must.injectParamsAndBoost(jsonMust);
            input.put("must", jsonMust);
        }
        if (!mustNotIsEmpty) {
            JsonObject jsonMustNot = JsonObject.create();
            this.mustNot.injectParamsAndBoost(jsonMustNot);
            input.put("must_not", jsonMustNot);
        }
        if (!shouldIsEmpty) {
            JsonObject jsonShould = JsonObject.create();
            this.should.injectParamsAndBoost(jsonShould);
            input.put("should", jsonShould);
        }
    }
}

