/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.parser;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.parser.DmdbExecOpt;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.Lexer;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLProcessor {
    public static List<LVal> lex(String sql) throws IOException {
        Lexer lexer = new Lexer(new StringReader(sql), false);
        int position = 0;
        LVal lval = null;
        ArrayList<LVal> lvalList = new ArrayList<LVal>(32);
        while ((lval = lexer.yylex()) != null) {
            lval.position = position++;
            lvalList.add(lval);
        }
        return lvalList;
    }

    public static String escape(String sql, String[] keywords) throws IOException {
        HashMap keywordMap = null;
        if (keywords != null && keywords.length > 0) {
            keywordMap = new HashMap();
            String[] stringArray = keywords;
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                keywordMap.put(keyword.toUpperCase(), null);
                ++n2;
            }
        }
        StringBuilder nsql = new StringBuilder();
        Stack<Boolean> stack = new Stack<Boolean>();
        List<LVal> lvalList = SQLProcessor.lex(sql);
        int i = 0;
        while (i < lvalList.size()) {
            LVal lval0 = lvalList.get(i);
            if (lval0.type == LVal.Type.NORMAL) {
                if (StringUtil.equals(lval0.value, "{")) {
                    LVal lval2;
                    LVal lval1 = SQLProcessor.next(lvalList, i + 1);
                    if (lval1 == null || lval1.type != LVal.Type.NORMAL) {
                        stack.push(false);
                        nsql.append(lval0.value);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "escape") || StringUtil.equalsIgnoreCase(lval1.value, "call")) {
                        stack.push(true);
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "oj")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "d")) {
                        stack.push(true);
                        lval1.value = "date";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "t")) {
                        stack.push(true);
                        lval1.value = "time";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "ts")) {
                        stack.push(true);
                        lval1.value = "datetime";
                    } else if (StringUtil.equalsIgnoreCase(lval1.value, "fn")) {
                        stack.push(true);
                        lval1.value = "";
                        lval1.type = LVal.Type.WHITESPACE_OR_COMMENT;
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "database")) {
                            lval2.value = "cur_database";
                        }
                    } else if (StringUtil.equals(lval1.value, "?")) {
                        lval2 = SQLProcessor.next(lvalList, lval1.position + 1);
                        if (lval2 != null && lval2.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval2.value, "=")) {
                            LVal lval3 = SQLProcessor.next(lvalList, lval2.position + 1);
                            if (lval3 != null && lval3.type == LVal.Type.NORMAL && StringUtil.equalsIgnoreCase(lval3.value, "call")) {
                                stack.push(true);
                                lval3.value = "";
                                lval3.type = LVal.Type.WHITESPACE_OR_COMMENT;
                            } else {
                                stack.push(false);
                                nsql.append(lval0.value);
                            }
                        } else {
                            stack.push(false);
                            nsql.append(lval0.value);
                        }
                    } else {
                        stack.push(false);
                        nsql.append(lval0.value);
                    }
                } else if (StringUtil.equals(lval0.value, "}")) {
                    if (stack.isEmpty() || !((Boolean)stack.pop()).booleanValue()) {
                        nsql.append(lval0.value);
                    }
                } else if (keywordMap != null && keywordMap.containsKey(lval0.value.toUpperCase())) {
                    nsql.append("\"" + StringUtil.processDoubleQuoteOfName(lval0.value.toUpperCase()) + "\"");
                } else {
                    nsql.append(lval0.value);
                }
            } else if (lval0.type == LVal.Type.STRING) {
                nsql.append("'" + StringUtil.processSingleQuoteOfName(lval0.value) + '\'');
            } else {
                nsql.append(lval0.value);
            }
            ++i;
        }
        return nsql.toString();
    }

    private static LVal next(List<LVal> lvalList, int start) {
        LVal lval = null;
        int size = lvalList.size();
        int i = start;
        while (i < size) {
            lval = lvalList.get(i);
            if (lval.type != LVal.Type.WHITESPACE_OR_COMMENT) break;
            ++i;
        }
        return lval;
    }

    public static DmdbExecOpt execOpt(String sql, String serverEncoding) throws IOException, SQLException {
        DmdbExecOpt execOpt = new DmdbExecOpt();
        List<LVal> lvalList = SQLProcessor.lex(sql);
        int breakIndex = 0;
        int i = 0;
        while (i < lvalList.size()) {
            LVal lval = lvalList.get(i);
            switch (lval.type) {
                case NULL: {
                    execOpt.addSqlWord("?");
                    execOpt.addParam(new Parameter(null, 25, 4));
                    break;
                }
                case INT: {
                    execOpt.addSqlWord("?");
                    Number value = new Long(lval.value);
                    if ((Long)value <= Integer.MAX_VALUE && (Long)value >= Integer.MIN_VALUE) {
                        execOpt.addParam(new Parameter(Convertion.intToByteArray(((Long)value).intValue()), 7, 4));
                        break;
                    }
                    execOpt.addParam(new Parameter(Convertion.longToByteArray((Long)value), 8, 8));
                    break;
                }
                case DOUBLE: {
                    execOpt.addSqlWord("?");
                    Number value = new Double(lval.value);
                    execOpt.addParam(new Parameter(Convertion.doubleToByteArray((Double)value), 11, 8));
                    break;
                }
                case DECIMAL: {
                    execOpt.addSqlWord("?");
                    execOpt.addParam(new Parameter(new DmdbNumeric().StrToDec(lval.value, 0, 0), 9, 0));
                    break;
                }
                case STRING: {
                    if (lval.value.length() > Short.MAX_VALUE) {
                        execOpt.addSqlWord("'" + StringUtil.processSingleQuoteOfName(lval.value) + "'");
                        break;
                    }
                    execOpt.addSqlWord("?");
                    execOpt.addParam(new Parameter(lval.value.getBytes(serverEncoding), 2, 8188));
                    break;
                }
                case HEX_INT: {
                    execOpt.addSqlWord(lval.value);
                    break;
                }
                default: {
                    execOpt.addSqlWord(lval.value);
                }
            }
            if (breakIndex > 0) break;
            ++i;
        }
        if (breakIndex > 0) {
            i = breakIndex + 1;
            while (i < lvalList.size()) {
                execOpt.addSqlWord(lvalList.get((int)i).value);
                ++i;
            }
        }
        return execOpt;
    }

    public static void main(String[] args) throws IOException, SQLException {
        String sql = "insert into TYYW_GG_XYRJBXX (BMSAH, TYSAH, XYRBH, SFSC, CBDW_BM, CBDW_MC, FQDWBM, FQL, CJSJ, ZHXGSJ, SFZF, XM, CYM, CH, XB_DM, XB_MC, ZASNL, CSRQ, CSD_DM, CSD_MC, ZJLX_DM, ZJLX_MC, ZJHM, MZ_DM, MZ_MC, GJ_DM, GJ_MC, HJSZD_DM, HJSZD_MC, ZSD_DM, ZSD_MC, ZSDXXDZ, GZDWSZD_DM, GZDWSZD_MC, GZDW, SF_DM, SF_MC, SJYZK_DM, SJYZK_MC, ZZMM_DM, ZZMM_MC, RDDB_DM, RDDB_MC, ZXWY_DM, ZXWY_MC, ZW, ZJ_DM, ZJ_MC, ZY_DM, ZY_MC, SFDRSZ, SFDWLD, SFNCJCZZRY, WCNFZXYRDJHRQK_DM, WCNFZXYRDJHRQK_MC, FDDLR, SZXXMC, DQQZCSBH, SFZT, JYKSRQ, JYDQRQ, JYYJZT, JYTS, NL, SFDWZFLD, SFWLJYSRDDB, SFWLJYSZXWY, SFCJZZRY, SFCJR, QTGZSF_DM, QTGZSF_MC, SFWDW)values( ?, '37000020190000300', '3700002019000001', 'N', '370000', '\u5c71\u4e1c\u7701\u9662', 3700, '2019','2019-02-15 08:25:42', '2019-02-15 08:25:43', 'N', '\u5f20\u4e09', null, null, '9909180000001', '\u7537\u6027', 32, '1987-09-09', null, null, '9910180300001', '\u5c45\u6c11\u8eab\u4efd\u8bc1', '222222198709091111', '9912180100001', '\u6c49\u65cf', '9911180200001', '\u4e2d\u56fd', '9913000220000', '\u5409\u6797\u7701', '9913000310000', '\u4e0a\u6d77\u5e02', '\u4e0a\u6d77\u5e02\u95f5\u884c\u533a\u91d1\u4e61\u5c0f\u533a40\u680b17\u53f7', '9913000210000', '\u8fbd\u5b81\u7701', '\u4e0a\u6d77\u5e02\u95f5\u884c\u533a\u91d1\u4e61\u5c0f\u533a40\u680b17\u53f7', '9916192603000', '\u5b66\u751f', '9915180600007', '\u9ad8\u804c', '9917180500001', '\u7fa4\u4f17', '9918181500005', '\u7701\u7ea7', '9919181400003', '\u5730\u5e02', null, '9914180800008', '\u53bf\u5904\u7ea7\u6b63\u804c', '9947199700008', '\u5316\u5de5\u4ea7\u54c1\u751f\u4ea7\u4eba\u5458', 'N', 'N', 'N', '9920182400004', '\u7236\u6bcd\u9057\u5f03', null, null, null, null, null, null, null, null, null, 'N', 'N', 'N', 'N', 'N', '9970010000500', '\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784', null)";
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < 1000) {
            SQLProcessor.execOpt(sql, "GB18030");
            ++i;
        }
        System.out.println("time: " + (System.currentTimeMillis() - start) + "ms");
    }

    public static class Parameter {
        public byte[] bytes;
        public byte ioType = 0;
        public int type;
        public int prec;
        public int scale = 0;

        public Parameter(byte[] bytes, int type, int prec) {
            this.bytes = bytes;
            this.type = type;
            this.prec = prec;
        }

        public String toString() {
            if (this.bytes == null) {
                return null;
            }
            return Arrays.toString(this.bytes);
        }
    }
}

