/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.processor.BaseThread;
import java.net.SocketException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;

public class RwStandbyRecoverThread
extends BaseThread {
    private static RwStandbyRecoverThread rwStandbyRecoverThread = null;
    private boolean stop = false;
    private static LinkedBlockingQueue<DmdbConnection_bs> queue;

    private RwStandbyRecoverThread() {
        super("RW-S-RECOVER-THREAD");
        queue = new LinkedBlockingQueue();
    }

    public static void addStandby(DmdbConnection_bs conn) {
        if (rwStandbyRecoverThread == null) {
            rwStandbyRecoverThread = new RwStandbyRecoverThread();
            rwStandbyRecoverThread.start();
        }
        queue.offer(conn);
    }

    public static void removeStandby(DmdbConnection_bs conn) {
        queue.remove(conn);
    }

    public void run() {
        while (!this.stop) {
            try {
                boolean flag;
                DmdbConnection_bs conn = queue.take();
                if (conn.isClosed() || !conn.getRwSeparate() || conn.getDbAccess().isStandbyAlive() || !(flag = DmdbCSI.connToStandby(conn)) || !this.checkStandbyValid(conn)) continue;
                conn.resetStandbyStatments();
                conn.getDbAccess().setStandbyAlive(true);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Loose catch block
     */
    private boolean checkStandbyValid(DmdbConnection_bs conn) throws SQLException {
        block29: {
            int oldSoTimeout;
            DmdbStatement_bs stmt;
            block26: {
                block27: {
                    stmt = null;
                    int oguidPrimary = 0;
                    oldSoTimeout = 0;
                    stmt = (DmdbStatement_bs)conn.createStatement();
                    ResultSet rs = stmt.executeQuery("select oguid from v$instance", 1);
                    rs.next();
                    oguidPrimary = rs.getInt(1);
                    oldSoTimeout = conn.getDbAccess().getAccessStandby().getSocket().getSoTimeout();
                    conn.getDbAccess().getAccessStandby().getSocket().setSoTimeout(10000);
                    rs = stmt.executeQuery("select oguid from v$instance", 0);
                    rs.next();
                    if (oguidPrimary != rs.getInt(1)) break block26;
                    if (oldSoTimeout == 0) break block27;
                    try {
                        conn.getDbAccess().getAccessStandby().getSocket().setSoTimeout(oldSoTimeout);
                    }
                    catch (SocketException socketException) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
                catch (Exception exception) {
                    block28: {
                        try {
                            if (oldSoTimeout == 0) break block28;
                        }
                        catch (Throwable throwable) {
                            if (oldSoTimeout != 0) {
                                try {
                                    conn.getDbAccess().getAccessStandby().getSocket().setSoTimeout(oldSoTimeout);
                                }
                                catch (SocketException socketException) {}
                            }
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Exception exception2) {}
                            }
                            throw throwable;
                        }
                        try {
                            conn.getDbAccess().getAccessStandby().getSocket().setSoTimeout(oldSoTimeout);
                        }
                        catch (SocketException socketException) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception3) {}
                    }
                    break block29;
                }
            }
            if (oldSoTimeout != 0) {
                try {
                    conn.getDbAccess().getAccessStandby().getSocket().setSoTimeout(oldSoTimeout);
                }
                catch (SocketException socketException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public boolean isStop() {
        return this.stop;
    }
}

