/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat;

import dm.jdbc.util.stat.FilterUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStatValue {
    protected String id;
    protected String sql;
    private long sqlHash;
    protected String dataSource;
    protected String dataSourceId;
    protected long executeLastStartTime;
    protected long executeBatchSizeTotal;
    protected int executeBatchSizeMax;
    protected long executeSuccessCount;
    protected long executeSpanNanoTotal;
    protected long executeSpanNanoMax;
    protected int runningCount;
    protected int concurrentMax;
    protected long resultSetHoldTimeNano;
    protected long executeAndResultSetHoldTime;
    protected String name;
    protected String file;
    protected String dbType;
    protected long executeNanoSpanMaxOccurTime;
    protected long executeErrorCount;
    protected Throwable executeErrorLast;
    protected String executeErrorLastMessage;
    protected String executeErrorLastClass;
    protected String executeErrorLastStackTrace;
    protected long executeErrorLastTime;
    protected long updateCount;
    protected long updateCountMax;
    protected long fetchRowCount;
    protected long fetchRowCountMax;
    protected long inTransactionCount;
    protected String lastSlowParameters;
    protected long clobOpenCount;
    protected long blobOpenCount;
    protected long readStringLength;
    protected long readBytesLength;
    protected long inputStreamOpenCount;
    protected long readerOpenCount;
    protected long histogram_0_1;
    protected long histogram_1_10;
    protected int histogram_10_100;
    protected int histogram_100_1000;
    protected int histogram_1000_10000;
    protected int histogram_10000_100000;
    protected int histogram_100000_1000000;
    protected int histogram_1000000_more;
    protected long executeAndResultHoldTime_0_1;
    protected long executeAndResultHoldTime_1_10;
    protected int executeAndResultHoldTime_10_100;
    protected int executeAndResultHoldTime_100_1000;
    protected int executeAndResultHoldTime_1000_10000;
    protected int executeAndResultHoldTime_10000_100000;
    protected int executeAndResultHoldTime_100000_1000000;
    protected int executeAndResultHoldTime_1000000_more;
    protected long fetchRowCount_0_1;
    protected long fetchRowCount_1_10;
    protected long fetchRowCount_10_100;
    protected int fetchRowCount_100_1000;
    protected int fetchRowCount_1000_10000;
    protected int fetchRowCount_10000_more;
    protected long updateCount_0_1;
    protected long updateCount_1_10;
    protected long updateCount_10_100;
    protected int updateCount_100_1000;
    protected int updateCount_1000_10000;
    protected int updateCount_10000_more;

    public long[] getExecuteHistogram() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getExecuteAndResultHoldHistogram() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long[] getFetchRowHistogram() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateHistogram() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long getExecuteCount() {
        return this.executeErrorCount + this.executeSuccessCount;
    }

    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public long getSqlHash() {
        return this.sqlHash;
    }

    public void setSqlHash(long sqlHash) {
        this.sqlHash = sqlHash;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public long getExecuteLastStartTimeMillis() {
        return this.executeLastStartTime;
    }

    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long executeLastStartTime) {
        this.executeLastStartTime = executeLastStartTime;
    }

    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void setExecuteBatchSizeTotal(long executeBatchSizeTotal) {
        this.executeBatchSizeTotal = executeBatchSizeTotal;
    }

    public int getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public void setExecuteBatchSizeMax(int executeBatchSizeMax) {
        this.executeBatchSizeMax = executeBatchSizeMax;
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void setExecuteSuccessCount(long executeSuccessCount) {
        this.executeSuccessCount = executeSuccessCount;
    }

    public long getExecuteSpanNanoTotal() {
        return this.executeSpanNanoTotal;
    }

    public void setExecuteSpanNanoTotal(long executeSpanNanoTotal) {
        this.executeSpanNanoTotal = executeSpanNanoTotal;
    }

    public long getExecuteSpanNanoMax() {
        return this.executeSpanNanoMax;
    }

    public void setExecuteSpanNanoMax(long executeSpanNanoMax) {
        this.executeSpanNanoMax = executeSpanNanoMax;
    }

    public int getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(int runningCount) {
        this.runningCount = runningCount;
    }

    public int getConcurrentMax() {
        return this.concurrentMax;
    }

    public void setConcurrentMax(int concurrentMax) {
        this.concurrentMax = concurrentMax;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public void setResultSetHoldTimeNano(long resultSetHoldTimeNano) {
        this.resultSetHoldTimeNano = resultSetHoldTimeNano;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void setExecuteAndResultSetHoldTime(long executeAndResultSetHoldTime) {
        this.executeAndResultSetHoldTime = executeAndResultSetHoldTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public long getExecuteNanoSpanMaxOccurTimeMillis() {
        return this.executeNanoSpanMaxOccurTime;
    }

    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void setExecuteNanoSpanMaxOccurTime(long executeNanoSpanMaxOccurTime) {
        this.executeNanoSpanMaxOccurTime = executeNanoSpanMaxOccurTime;
    }

    public long getExecuteErrorCount() {
        return this.executeErrorCount;
    }

    public void setExecuteErrorCount(long executeErrorCount) {
        this.executeErrorCount = executeErrorCount;
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void setExecuteErrorLast(Throwable executeErrorLast) {
        this.executeErrorLast = executeErrorLast;
        if (executeErrorLast != null) {
            this.executeErrorLastMessage = executeErrorLast.getMessage();
            this.executeErrorLastClass = executeErrorLast.getClass().getName();
            this.executeErrorLastStackTrace = FilterUtil.toString(executeErrorLast.getStackTrace());
        }
    }

    public String getExecuteErrorLastMessage() {
        return this.executeErrorLastMessage;
    }

    public String getExecuteErrorLastClass() {
        return this.executeErrorLastClass;
    }

    public String getExecuteErrorLastStackTrace() {
        return this.executeErrorLastStackTrace;
    }

    public long getExecuteErrorLastTimeMillis() {
        return this.executeErrorLastTime;
    }

    public void setExecuteErrorLastTime(long executeErrorLastTime) {
        this.executeErrorLastTime = executeErrorLastTime;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public void setUpdateCount(long updateCount) {
        this.updateCount = updateCount;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    public void setUpdateCountMax(long updateCountMax) {
        this.updateCountMax = updateCountMax;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public void setFetchRowCount(long fetchRowCount) {
        this.fetchRowCount = fetchRowCount;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public void setFetchRowCountMax(long fetchRowCountMax) {
        this.fetchRowCountMax = fetchRowCountMax;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void setInTransactionCount(long inTransactionCount) {
        this.inTransactionCount = inTransactionCount;
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String lastSlowParameters) {
        this.lastSlowParameters = lastSlowParameters;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void setClobOpenCount(long clobOpenCount) {
        this.clobOpenCount = clobOpenCount;
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void setBlobOpenCount(long blobOpenCount) {
        this.blobOpenCount = blobOpenCount;
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void setReadStringLength(long readStringLength) {
        this.readStringLength = readStringLength;
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void setReadBytesLength(long readBytesLength) {
        this.readBytesLength = readBytesLength;
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void setInputStreamOpenCount(long inputStreamOpenCount) {
        this.inputStreamOpenCount = inputStreamOpenCount;
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void setReaderOpenCount(long readerOpenCount) {
        this.readerOpenCount = readerOpenCount;
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public Map<String, Object> getData() throws JMException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ID", this.id);
        map.put("DataSource", this.dataSource);
        map.put("DataSourceId", this.dataSourceId);
        map.put("SQL", this.sql);
        map.put("ExecuteCount", this.getExecuteCount());
        map.put("ErrorCount", this.getExecuteErrorCount());
        map.put("TotalTime", this.getExecuteMillisTotal());
        map.put("LastTime", this.getExecuteLastStartTime());
        map.put("MaxTimespan", this.getExecuteMillisMax());
        map.put("LastError", FilterUtil.getErrorCompositeData(this.getExecuteErrorLast()));
        map.put("EffectedRowCount", this.getUpdateCount());
        map.put("FetchRowCount", this.getFetchRowCount());
        map.put("MaxTimespanOccurTime", this.getExecuteNanoSpanMaxOccurTime());
        map.put("BatchSizeMax", Long.valueOf(this.getExecuteBatchSizeMax()));
        map.put("BatchSizeTotal", this.getExecuteBatchSizeTotal());
        map.put("ConcurrentMax", Long.valueOf(this.getConcurrentMax()));
        map.put("RunningCount", Long.valueOf(this.getRunningCount()));
        map.put("Name", this.getName());
        map.put("File", this.getFile());
        if (this.executeErrorLastMessage != null) {
            map.put("LastErrorMessage", this.executeErrorLastMessage);
            map.put("LastErrorClass", this.executeErrorLastClass);
            map.put("LastErrorStackTrace", this.executeErrorLastStackTrace);
            map.put("LastErrorTime", new Date(this.executeErrorLastTime));
        } else {
            map.put("LastErrorMessage", null);
            map.put("LastErrorClass", null);
            map.put("LastErrorStackTrace", null);
            map.put("LastErrorTime", null);
        }
        map.put("DbType", this.dbType);
        map.put("URL", null);
        map.put("InTransactionCount", this.getInTransactionCount());
        map.put("Histogram", this.getHistogramValues());
        map.put("LastSlowParameters", this.lastSlowParameters);
        map.put("ResultSetHoldTime", this.getResultSetHoldTimeMilis());
        map.put("ExecuteAndResultSetHoldTime", this.getExecuteAndResultSetHoldTimeMilis());
        map.put("FetchRowCountHistogram", this.getFetchRowCountHistogramValues());
        map.put("EffectedRowCountHistogram", this.getUpdateCountHistogramValues());
        map.put("ExecuteAndResultHoldTimeHistogram", this.getExecuteAndResultHoldTimeHistogramValues());
        map.put("EffectedRowCountMax", this.getUpdateCountMax());
        map.put("FetchRowCountMax", this.getFetchRowCountMax());
        map.put("ClobOpenCount", this.getClobOpenCount());
        map.put("BlobOpenCount", this.getBlobOpenCount());
        map.put("ReadStringLength", this.getReadStringLength());
        map.put("ReadBytesLength", this.getReadBytesLength());
        map.put("InputStreamOpenCount", this.getInputStreamOpenCount());
        map.put("ReaderOpenCount", this.getReaderOpenCount());
        map.put("HASH", this.getSqlHash());
        map.put("ExecuteHoldTimeHistogram", this.getExecuteHistogram());
        return map;
    }

    public long getHistogram_0_1() {
        return this.histogram_0_1;
    }

    public void setHistogram_0_1(long histogram_0_1) {
        this.histogram_0_1 = histogram_0_1;
    }

    public long getHistogram_1_10() {
        return this.histogram_1_10;
    }

    public void setHistogram_1_10(long histogram_1_10) {
        this.histogram_1_10 = histogram_1_10;
    }

    public int getHistogram_10_100() {
        return this.histogram_10_100;
    }

    public void setHistogram_10_100(int histogram_10_100) {
        this.histogram_10_100 = histogram_10_100;
    }

    public int getHistogram_100_1000() {
        return this.histogram_100_1000;
    }

    public void setHistogram_100_1000(int histogram_100_1000) {
        this.histogram_100_1000 = histogram_100_1000;
    }

    public int getHistogram_1000_10000() {
        return this.histogram_1000_10000;
    }

    public void setHistogram_1000_10000(int histogram_1000_10000) {
        this.histogram_1000_10000 = histogram_1000_10000;
    }

    public int getHistogram_10000_100000() {
        return this.histogram_10000_100000;
    }

    public void setHistogram_10000_100000(int histogram_10000_100000) {
        this.histogram_10000_100000 = histogram_10000_100000;
    }

    public int getHistogram_100000_1000000() {
        return this.histogram_100000_1000000;
    }

    public void setHistogram_100000_1000000(int histogram_100000_1000000) {
        this.histogram_100000_1000000 = histogram_100000_1000000;
    }

    public int getHistogram_1000000_more() {
        return this.histogram_1000000_more;
    }

    public void setHistogram_1000000_more(int histogram_1000000_more) {
        this.histogram_1000000_more = histogram_1000000_more;
    }
}

