/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.Convertion;
import dm.jdbc.dataConvertion.accessor.DatetimeAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DmdbTimestamp {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    public static final int TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public int[] dt;
    public int dtype = 16;
    public int scale = 6;

    public DmdbTimestamp(int[] dt, int dtype, int scale) {
        this.dt = dt;
        this.dtype = dtype;
        this.scale = scale;
    }

    public static DmdbTimestamp valueOf(String str) throws SQLException {
        int dtype;
        int[] dt;
        return new DmdbTimestamp(dt, dtype, (dtype = DmdbTimestamp.toDT(str, dt = new int[8])) == 14 ? 0 : 6);
    }

    public static DmdbTimestamp valueOf(java.sql.Date date) throws SQLException {
        int[] dt = DmdbTimestamp.toDT(date.getTime(), 0L, null);
        return new DmdbTimestamp(dt, 14, 0);
    }

    public static DmdbTimestamp valueOf(Time time) throws SQLException {
        int[] dt = DmdbTimestamp.toDT(time.getTime(), 0L, null);
        return new DmdbTimestamp(dt, 15, 6);
    }

    public static DmdbTimestamp valueOf(Timestamp ts) throws SQLException {
        int[] dt = DmdbTimestamp.toDT(ts.getTime(), ts.getNanos(), null);
        return new DmdbTimestamp(dt, 16, 6);
    }

    public static byte[] encodeByString(String x, int dtype, int scale, int ltz, int dtz) throws SQLException {
        int[] dt = new int[8];
        DmdbTimestamp.toDT(x, dt);
        return DmdbTimestamp.encode(dt, dtype, scale, ltz);
    }

    public static byte[] encodeByDate(Date x, int dtype, int scale, Calendar calendar, int lTz, int dbTz) throws SQLException {
        int nano = 0;
        if (x instanceof Timestamp) {
            nano = ((Timestamp)x).getNanos();
        }
        int[] dt = DmdbTimestamp.toDT(x.getTime(), nano, calendar);
        return DmdbTimestamp.encode(dt, dtype, scale, lTz);
    }

    public static byte[] encodeByDateNumber(long x, int destDType, int destScale, Calendar defaultCalendar, short lTz, short dbTz) throws SQLException {
        byte[] ret = null;
        switch (destDType) {
            case 16: {
                if (x > 255611203200L) {
                    DBError.throwSQLException(-2512);
                }
                int[] dt = DmdbTimestamp.toDT(x * 1000L - 2209017600000L, 0L, defaultCalendar);
                ret = DmdbTimestamp.encode(dt, destDType, destScale, lTz);
                break;
            }
            case 15: {
                int[] dt = DmdbTimestamp.toDT(x * 1000L, 0L, defaultCalendar);
                ret = DmdbTimestamp.encode(dt, destDType, destScale, lTz);
                break;
            }
            case 14: {
                if (x > 2958463L) {
                    DBError.throwSQLException(-2512);
                }
                int[] dt = DmdbTimestamp.toDT(x * 24L * 60L * 60L * 1000L - 2209017600000L, 0L, defaultCalendar);
                ret = DmdbTimestamp.encode(dt, destDType, destScale, lTz);
                break;
            }
            default: {
                DBError.throwSQLException(6007);
            }
        }
        return ret;
    }

    public static java.sql.Date toDate(String str, Calendar calendar) throws SQLException {
        int[] dt = new int[8];
        DmdbTimestamp.toDT(str, dt);
        return new java.sql.Date(DmdbTimestamp.toTimeInMillis(dt, calendar));
    }

    public static Time toTime(String str, Calendar calendar) throws SQLException {
        int[] dt = new int[8];
        DmdbTimestamp.toDT(str, dt);
        return new Time(DmdbTimestamp.toTimeInMillis(dt, calendar));
    }

    public static Timestamp toTimestamp(String str, Calendar calendar) throws SQLException {
        int[] dt = new int[8];
        DmdbTimestamp.toDT(str, dt);
        Timestamp ts = new Timestamp(DmdbTimestamp.toTimeInMillis(dt, calendar));
        ts.setNanos(dt[6] * 1000);
        return ts;
    }

    public java.sql.Date toDate() throws SQLException {
        return new java.sql.Date(DmdbTimestamp.toTimeInMillis(this.dt, null));
    }

    public Time toTime() throws SQLException {
        return new Time(DmdbTimestamp.toTimeInMillis(this.dt, null));
    }

    public Timestamp toTimestamp() throws SQLException {
        Timestamp ts = new Timestamp(DmdbTimestamp.toTimeInMillis(this.dt, null));
        ts.setNanos(this.dt[6] * 1000);
        return ts;
    }

    public String toString() {
        return DmdbTimestamp.toString(this.getDt(), this.dtype, this.scale);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp objTs = (DmdbTimestamp)obj;
        if (this.dt != null && objTs.dt != null) {
            return Arrays.equals(this.dt, objTs.dt);
        }
        return false;
    }

    public byte[] encodeToDestType(int destType, int scale, short ltz) throws SQLException {
        return DmdbTimestamp.encode(this.getDt(), destType, scale, ltz);
    }

    public int[] getDt() {
        return this.dt;
    }

    public static String toString(int[] dt, int dtype, int scale) {
        switch (dtype) {
            case 14: {
                return String.valueOf(DmdbTimestamp.formatYear(dt[0])) + "-" + DmdbTimestamp.format2(dt[1]) + "-" + DmdbTimestamp.format2(dt[2]);
            }
            case 15: {
                if (scale > 0) {
                    return String.valueOf(DmdbTimestamp.format2(dt[3])) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + "." + DmdbTimestamp.formatMilliSecond(dt[6], scale);
                }
                return String.valueOf(DmdbTimestamp.format2(dt[3])) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]);
            }
            case 22: {
                if (scale > 0) {
                    return String.valueOf(DmdbTimestamp.format2(dt[3])) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + "." + DmdbTimestamp.formatMilliSecond(dt[6], scale) + " " + DmdbTimestamp.formatTZ(dt[7]);
                }
                return String.valueOf(DmdbTimestamp.format2(dt[3])) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + " " + DmdbTimestamp.formatTZ(dt[7]);
            }
            case 16: {
                if (DmdbType.isLocalTimeZone(dtype, scale)) {
                    scale = DmdbType.localTimeZoneRealPrec(scale);
                }
                if (scale > 0) {
                    return String.valueOf(DmdbTimestamp.formatYear(dt[0])) + "-" + DmdbTimestamp.format2(dt[1]) + "-" + DmdbTimestamp.format2(dt[2]) + " " + DmdbTimestamp.format2(dt[3]) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + "." + DmdbTimestamp.formatMilliSecond(dt[6], scale);
                }
                return String.valueOf(DmdbTimestamp.formatYear(dt[0])) + "-" + DmdbTimestamp.format2(dt[1]) + "-" + DmdbTimestamp.format2(dt[2]) + " " + DmdbTimestamp.format2(dt[3]) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]);
            }
            case 23: {
                if (scale > 0) {
                    return String.valueOf(DmdbTimestamp.formatYear(dt[0])) + "-" + DmdbTimestamp.format2(dt[1]) + "-" + DmdbTimestamp.format2(dt[2]) + " " + DmdbTimestamp.format2(dt[3]) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + "." + DmdbTimestamp.formatMilliSecond(dt[6], scale) + " " + DmdbTimestamp.formatTZ(dt[7]);
                }
                return String.valueOf(DmdbTimestamp.formatYear(dt[0])) + "-" + DmdbTimestamp.format2(dt[1]) + "-" + DmdbTimestamp.format2(dt[2]) + " " + DmdbTimestamp.format2(dt[3]) + ":" + DmdbTimestamp.format2(dt[4]) + ":" + DmdbTimestamp.format2(dt[5]) + " " + DmdbTimestamp.formatTZ(dt[7]);
            }
        }
        return "";
    }

    static int[] toDT(long timeInMillis, long nano, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTimeInMillis(timeInMillis);
        int[] ts = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), (int)(nano / 1000L), Integer.MIN_VALUE};
        return ts;
    }

    static int toDT(String s, int[] dt) throws SQLException {
        try {
            String date_s = null;
            String time_s = null;
            String nanos_s = null;
            String tz_s = null;
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int a_nanos = 0;
            int firstColon = 0;
            int secondColon = 0;
            int period = 0;
            boolean sign = false;
            int ownTz = Integer.MIN_VALUE;
            int dtype = 0;
            String zeros = "000000000";
            if (s == null) {
                throw new IllegalArgumentException("null string");
            }
            if ((s = s.trim()).startsWith("-", 0)) {
                s = s.substring(1).trim();
                sign = true;
            }
            String[] comps = s.split(" ");
            switch (comps.length) {
                case 3: {
                    date_s = comps[0];
                    time_s = comps[1];
                    tz_s = comps[2];
                    dtype = 23;
                    break;
                }
                case 2: {
                    if (comps[0].indexOf(":") > 0) {
                        time_s = comps[0];
                        tz_s = comps[1];
                        dtype = 22;
                        break;
                    }
                    date_s = comps[0];
                    time_s = comps[1];
                    dtype = 16;
                    break;
                }
                case 1: {
                    if (comps[0].indexOf(":") > 0) {
                        time_s = comps[0];
                        dtype = 15;
                        break;
                    }
                    date_s = comps[0];
                    dtype = 14;
                    break;
                }
                default: {
                    throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
            if (date_s != null) {
                int firstDash = date_s.indexOf(45);
                int secondDash = date_s.indexOf(45, firstDash + 1);
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(46);
                    secondDash = s.indexOf(46, firstDash + 1);
                }
                if (firstDash < 0 || secondDash < 0) {
                    firstDash = s.indexOf(47);
                    secondDash = s.indexOf(47, firstDash + 1);
                }
                if (firstDash > 0 & secondDash > 0 & secondDash < date_s.length() - 1) {
                    year = sign ? 0 - Integer.parseInt(date_s.substring(0, firstDash)) - 1900 : Integer.parseInt(date_s.substring(0, firstDash)) - 1900;
                    if (!DmdbTimestamp.checkDate(year + 1900, (month = Integer.parseInt(date_s.substring(firstDash + 1, secondDash)) - 1) + 1, day = Integer.parseInt(date_s.substring(secondDash + 1)))) {
                        throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                } else {
                    throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
            if (time_s != null) {
                firstColon = time_s.indexOf(58);
                secondColon = time_s.indexOf(58, firstColon + 1);
                period = time_s.indexOf(46, secondColon + 1);
                if (firstColon > 0 & secondColon > 0 & secondColon < time_s.length() - 1) {
                    hour = Integer.parseInt(time_s.substring(0, firstColon));
                    minute = Integer.parseInt(time_s.substring(firstColon + 1, secondColon));
                    if (period > 0 & period < time_s.length() - 1) {
                        second = Integer.parseInt(time_s.substring(secondColon + 1, period));
                        nanos_s = time_s.substring(period + 1);
                        if (nanos_s.length() > 9) {
                            throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        if (!Character.isDigit(nanos_s.charAt(0))) {
                            throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        nanos_s = String.valueOf(nanos_s) + zeros.substring(0, 9 - nanos_s.length());
                        a_nanos = Integer.valueOf(nanos_s.substring(0, 6));
                    } else {
                        if (period > 0) {
                            throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                        }
                        second = Integer.parseInt(time_s.substring(secondColon + 1));
                    }
                    if (hour > 24 || hour < 0 || minute > 60 || minute < 0 || second > 60 || second < 0) {
                        throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                } else {
                    throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
            if (tz_s != null) {
                boolean neg = false;
                if (tz_s.startsWith("-")) {
                    neg = true;
                }
                if (tz_s.startsWith("-") || tz_s.startsWith("+")) {
                    tz_s = tz_s.substring(1).trim();
                }
                String[] hm = tz_s.split(":");
                short tzh = 0;
                short tzm = 0;
                switch (hm.length) {
                    case 2: {
                        tzh = Short.parseShort(hm[0].trim());
                        tzm = Short.parseShort(hm[1].trim());
                        break;
                    }
                    case 1: {
                        tzh = Short.parseShort(hm[0].trim());
                        break;
                    }
                    default: {
                        throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                    }
                }
                ownTz = (short)(tzh * 60 + tzm);
                if (ownTz < 0) {
                    throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                }
                if (neg) {
                    ownTz *= -1;
                }
                if (ownTz <= -780 || ownTz > 840) {
                    throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
                }
            }
            dt[0] = year + 1900;
            dt[1] = month + 1;
            dt[2] = day == 0 ? 1 : day;
            dt[3] = hour;
            dt[4] = minute;
            dt[5] = second;
            dt[6] = a_nanos;
            dt[7] = ownTz;
            return dtype;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new SQLException(DmSvcConf.res.getString("error.invalidDateTimeTypeFormat"));
        }
    }

    public static long toTimeInMillis(int[] dt, Calendar calendar) {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.set(dt[0] == 0 ? 1970 : dt[0], dt[1] > 0 ? dt[1] - 1 : 0, dt[2] == 0 ? 1 : dt[2], dt[3], dt[4], dt[5]);
        calendar.set(14, 0);
        if (dt[0] >= 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return calendar.getTimeInMillis();
    }

    static byte[] encode(int[] dt, int dtype, int scale, int lTz) throws SQLException {
        if (DmdbType.isLocalTimeZone(dtype, scale) && dt[7] != Integer.MIN_VALUE && dt[7] != lTz) {
            DatetimeAccessor.transitTZ(dt, dt[7], lTz);
        }
        int year = dt[0];
        int month = dt[1];
        int day = dt[2];
        int hour = dt[3];
        int min = dt[4];
        int sec = dt[5];
        int msec = dt[6];
        int tz = dt[7] == Integer.MIN_VALUE ? lTz : dt[7];
        byte[] ret = null;
        if (dtype == 14) {
            ret = new byte[]{(byte)(year & 0xFF), year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F)), (byte)((month & 0xE) >> 1 | day << 3)};
        } else if (dtype == 16) {
            ret = new byte[]{(byte)(year & 0xFF), year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F)), (byte)((month & 0xE) >> 1 | day << 3), (byte)(hour | (min & 7) << 5), (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3), (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1), (byte)(msec >> 7 & 0xFF), (byte)(msec >> 15 & 0xFF)};
        } else if (dtype == 23) {
            ret = new byte[10];
            ret[0] = (byte)(year & 0xFF);
            ret[1] = year >= 0 ? (byte)(year >> 8 | (month & 1) << 7) : (byte)(year >> 8 & ((month & 1) << 7 | 0x7F));
            ret[2] = (byte)((month & 0xE) >> 1 | day << 3);
            ret[3] = (byte)(hour | (min & 7) << 5);
            ret[4] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
            ret[5] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
            ret[6] = (byte)(msec >> 7 & 0xFF);
            ret[7] = (byte)(msec >> 15 & 0xFF);
            Convertion.setShort(ret, 8, (short)tz);
        } else if (dtype == 15) {
            ret = new byte[]{(byte)(hour | (min & 7) << 5), (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3), (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1), (byte)(msec >> 7 & 0xFF), (byte)(msec >> 15 & 0xFF)};
        } else if (dtype == 22) {
            ret = new byte[7];
            ret[0] = (byte)(hour | (min & 7) << 5);
            ret[1] = (byte)((min & 0x38) >> 3 | (sec & 0x1F) << 3);
            ret[2] = (byte)((sec & 0x20) >> 5 | (msec & 0x7F) << 1);
            ret[3] = (byte)(msec >> 7 & 0xFF);
            ret[4] = (byte)(msec >> 15 & 0xFF);
            Convertion.setShort(ret, 5, (short)tz);
        }
        return ret;
    }

    static String formatMilliSecond(int ms, int prec) {
        String ret = null;
        ret = ms < 10 ? "00000" + ms : (ms < 100 ? "0000" + ms : (ms < 1000 ? "000" + ms : (ms < 10000 ? "00" + ms : (ms < 100000 ? "0" + ms : Integer.toString(ms)))));
        if (prec < 6) {
            ret = ret.substring(0, prec);
        }
        return ret;
    }

    static String formatTZ(int tz) {
        int tz_hour = Math.abs(tz / 60);
        int tz_min = Math.abs(tz % 60);
        if (tz >= 0) {
            return "+" + DmdbTimestamp.format2(tz_hour) + ":" + DmdbTimestamp.format2(tz_min);
        }
        return "-" + DmdbTimestamp.format2(tz_hour) + ":" + DmdbTimestamp.format2(tz_min);
    }

    static String formatYear(int value) {
        if (value >= 0) {
            if (value < 10) {
                return "000" + value;
            }
            if (value < 100) {
                return "00" + value;
            }
            if (value < 1000) {
                return "0" + value;
            }
            return Integer.toString(value);
        }
        if (value > -10) {
            return "-000" + -value;
        }
        if (value > -100) {
            return "-00" + -value;
        }
        if (value > -1000) {
            return "-0" + -value;
        }
        return Integer.toString(value);
    }

    static String format2(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    static boolean checkDate(int year, int month, int day) {
        if (year > 9999 || month > 12 || month < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (day <= 31 && day >= 1) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (day <= 30 && day >= 1) break;
                return false;
            }
            case 2: {
                if (!(DmdbTimestamp.dmdt_is_leap_year(year) ? day > 29 || day < 1 : day > 28 || day < 1)) break;
                return false;
            }
        }
        return true;
    }

    public static boolean dmdt_is_leap_year(int year) {
        if (year < 0) {
            year = -year;
        }
        if (year % 4 == 0) {
            return year % 100 != 0 || year % 400 == 0;
        }
        return false;
    }
}

