/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import java.util.Objects;

public class BoolFieldConvertor
implements FieldConvertor {
    private boolean ignoreCase = true;
    private String[] falseValues = new String[]{"0", "OFF", "FALSE", "N", "NO", "F"};

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType, Class<?> targetType) {
        return !(valueType != String.class && !Number.class.isAssignableFrom(valueType) || targetType != Boolean.TYPE && targetType != Boolean.class);
    }

    @Override
    public Object convert(FieldMeta meta, Object value, Class<?> targetType) {
        if (value instanceof String) {
            String bool = (String)value;
            for (String t : this.falseValues) {
                if (!t.equalsIgnoreCase(bool)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return ((Number)value).intValue() != 0;
    }

    public String[] getFalseValues() {
        return this.falseValues;
    }

    public void setFalseValues(String[] falseValues) {
        this.falseValues = Objects.requireNonNull(falseValues);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

