/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.FieldConvertor;
import com.ejlchina.searcher.FieldMeta;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DateFormatFieldConvertor
implements FieldConvertor {
    private final Map<String, Pattern> formatMap = new ConcurrentHashMap<String, Pattern>();
    private final ThreadLocal<Map<String, DateFormat>> local = new ThreadLocal();

    public void setFormat(String scope, String format) {
        this.formatMap.put(scope, new Pattern(format));
    }

    @Deprecated
    public void addFormat(String scope, String format) {
        this.setFormat(scope, format);
    }

    @Override
    public boolean supports(FieldMeta meta, Class<?> valueType, Class<?> targetType) {
        return Date.class.isAssignableFrom(valueType) && targetType == null;
    }

    @Override
    public Object convert(FieldMeta meta, Object value, Class<?> targetType) {
        Pattern pattern = this.getPattern(meta);
        if (pattern == null || pattern.format == null) {
            return value;
        }
        return this.getFormat(pattern.format).format((Date)value);
    }

    protected Pattern getPattern(FieldMeta meta) {
        Class<?> clazz = meta.getBeanMeta().getBeanClass();
        String className = clazz.getName();
        Pattern pattern = this.formatMap.get(className + "." + meta.getName());
        if (pattern != null) {
            return pattern;
        }
        pattern = this.formatMap.get(className);
        if (pattern != null) {
            return pattern;
        }
        String pkgName = className;
        int index = className.lastIndexOf(46);
        while (index > 0) {
            pattern = this.formatMap.get(pkgName = pkgName.substring(0, index));
            if (pattern != null) {
                return pattern;
            }
            index = pkgName.lastIndexOf(46);
        }
        return null;
    }

    private DateFormat getFormat(String pattern) {
        DateFormat format;
        Map<String, DateFormat> cache = this.local.get();
        if (cache == null) {
            cache = new HashMap<String, DateFormat>();
            this.local.set(cache);
        }
        if ((format = cache.get(pattern)) == null) {
            format = new SimpleDateFormat(pattern);
            cache.put(pattern, format);
        }
        return format;
    }

    public Map<String, Pattern> getFormatMap() {
        return this.formatMap;
    }

    public static class Pattern {
        final String format;

        public Pattern(String format) {
            this.format = format;
        }
    }
}

