/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlExecutor
implements SqlExecutor {
    protected Logger log = LoggerFactory.getLogger(DefaultSqlExecutor.class);
    private DataSource dataSource;
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private boolean transactional = false;

    public DefaultSqlExecutor() {
    }

    public DefaultSqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public <T> SqlResult<T> execute(SearchSql<T> searchSql) {
        Connection connection;
        if (!searchSql.isShouldQueryList() && !searchSql.isShouldQueryCluster()) {
            return new SqlResult<T>(searchSql);
        }
        try {
            connection = this.getConnection(searchSql.getBeanMeta());
        }
        catch (SQLException e) {
            throw new SearchException("Can not get connection from dataSource!", e);
        }
        try {
            return this.doExecute(searchSql, connection);
        }
        catch (SQLException e) {
            this.closeConnection(connection);
            throw new SearchException("A exception occurred when query!", e);
        }
    }

    protected Connection getConnection(BeanMeta<?> beanMeta) throws SQLException {
        String name = beanMeta.getDataSource();
        if (StringUtils.isBlank(name)) {
            if (this.dataSource == null) {
                throw new SearchException("There is no default dataSource for " + beanMeta.getBeanClass());
            }
            return this.dataSource.getConnection();
        }
        DataSource dataSource = this.dataSourceMap.get(name);
        if (dataSource == null) {
            throw new SearchException("There is no dataSource named " + name + " for " + beanMeta.getBeanClass());
        }
        return dataSource.getConnection();
    }

    protected <T> SqlResult<T> doExecute(SearchSql<T> searchSql, final Connection connection) throws SQLException {
        List<Object> params;
        String sql;
        if (this.transactional) {
            connection.setAutoCommit(false);
            connection.setReadOnly(true);
        }
        SqlResult result = new SqlResult<T>(searchSql){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    DefaultSqlExecutor.this.closeConnection(connection);
                }
            }
        };
        if (searchSql.isShouldQueryList()) {
            sql = searchSql.getListSqlString();
            params = searchSql.getListSqlParams();
            this.writeLog(sql, params);
            this.executeListSqlAndCollectResult(connection, sql, params, result);
        }
        if (searchSql.isShouldQueryCluster()) {
            sql = searchSql.getClusterSqlString();
            params = searchSql.getClusterSqlParams();
            this.writeLog(sql, params);
            this.executeClusterSqlAndCollectResult(connection, sql, params, result);
        }
        if (this.transactional) {
            connection.commit();
            connection.setReadOnly(false);
        }
        return result;
    }

    protected void writeLog(String sql, List<Object> params) {
        this.log.debug("bean-searcher - sql ---- {}", (Object)sql);
        this.log.debug("bean-searcher - params - {}", params);
    }

    protected void executeListSqlAndCollectResult(Connection connection, String sql, List<Object> params, SqlResult<?> sqlResult) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sql);
        this.setStatementParams(statement, params);
        ResultSet resultSet = statement.executeQuery();
        sqlResult.setListResult(resultSet, statement);
    }

    protected void executeClusterSqlAndCollectResult(Connection connection, String sqlString, List<Object> sqlParams, SqlResult<?> sqlResult) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(sqlString);
        this.setStatementParams(statement, sqlParams);
        ResultSet resultSet = statement.executeQuery();
        sqlResult.setClusterResult(resultSet, statement);
    }

    protected void setStatementParams(PreparedStatement statement, List<Object> params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            statement.setObject(i + 1, params.get(i));
        }
    }

    protected void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new SearchException("Can not close connection!", e);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void addDataSource(String name, DataSource dataSource) {
        if (name != null && dataSource != null) {
            this.dataSourceMap.put(name.trim(), dataSource);
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTransactional() {
        return this.transactional;
    }
}

