/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.java.emoji;

import com.github.binarywang.java.emoji.EmojiReader;
import com.github.binarywang.java.emoji.EmojiUtils;
import com.vdurmont.emoji.EmojiParser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmojiConverter {
    private static final Logger logger = LoggerFactory.getLogger(EmojiConverter.class);
    private static EmojiConverter instance = new EmojiConverter();

    private EmojiConverter() {
    }

    public static EmojiConverter getInstance() {
        return instance;
    }

    public String toAlias(String input) {
        String result;
        if (EmojiUtils.containsSbEmoji(input)) {
            input = EmojiConverter.sb2Unicode(input);
        }
        if ((result = EmojiParser.parseToAliases((String)input)).equals(EmojiParser.parseToAliases((String)result))) {
            return result;
        }
        return EmojiParser.parseToAliases((String)result);
    }

    private static String sb2Unicode(String input) {
        StringBuilder result = new StringBuilder();
        int[] codePoints = EmojiConverter.toCodePointArray(input);
        for (int i = 0; i < codePoints.length; ++i) {
            ArrayList<Integer> key2 = null;
            if (i + 1 < codePoints.length) {
                key2 = new ArrayList<Integer>();
                key2.add(codePoints[i]);
                key2.add(codePoints[i + 1]);
                if (EmojiReader.readSb2UnicodeMap().containsKey(key2)) {
                    String value = EmojiReader.readSb2UnicodeMap().get(key2);
                    if (value != null) {
                        result.append(value);
                    }
                    ++i;
                    continue;
                }
            }
            ArrayList<Integer> key1 = new ArrayList<Integer>();
            key1.add(codePoints[i]);
            if (EmojiReader.readSb2UnicodeMap().containsKey(key1)) {
                String value = EmojiReader.readSb2UnicodeMap().get(key1);
                if (value == null) continue;
                result.append(value);
                continue;
            }
            result.append(Character.toChars(codePoints[i]));
        }
        return result.toString();
    }

    private static int[] toCodePointArray(String str) {
        int cp;
        char[] ach = str.toCharArray();
        int len = ach.length;
        int[] acp = new int[Character.codePointCount(ach, 0, len)];
        int j = 0;
        for (int i = 0; i < len; i += Character.charCount(cp)) {
            cp = Character.codePointAt(ach, i);
            acp[j++] = cp;
        }
        return acp;
    }

    public String toHtml(String input) {
        String result;
        if (EmojiUtils.containsSbEmoji(input)) {
            input = EmojiConverter.sb2Unicode(input);
        }
        if ((result = EmojiParser.parseToHtmlDecimal((String)input)).equals(EmojiParser.parseToHtmlDecimal((String)result))) {
            return result;
        }
        return EmojiParser.parseToHtmlDecimal((String)result);
    }

    public String toUnicode(String input) {
        String result;
        if (EmojiUtils.containsSbEmoji(input)) {
            input = EmojiConverter.sb2Unicode(input);
        }
        if ((result = EmojiParser.parseToUnicode((String)input)).equals(EmojiParser.parseToUnicode((String)result))) {
            return result;
        }
        return EmojiParser.parseToUnicode((String)result);
    }
}

