/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.enums;

import me.chanjar.weixin.mp.bean.WxMpHostConfig;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;

public interface WxMpApiUrl {
    public String getUrl(WxMpConfigStorage var1);

    public static enum ImgProc implements WxMpApiUrl
    {
        QRCODE("https://api.weixin.qq.com", "/cv/img/qrcode?img_url=%s"),
        FILE_QRCODE("https://api.weixin.qq.com", "/cv/img/qrcode"),
        SUPER_RESOLUTION("https://api.weixin.qq.com", "/cv/img/superresolution?img_url=%s"),
        FILE_SUPER_RESOLUTION("https://api.weixin.qq.com", "/cv/img/superresolution"),
        AI_CROP("https://api.weixin.qq.com", "/cv/img/aicrop?img_url=%s&ratios=%s"),
        FILE_AI_CROP("https://api.weixin.qq.com", "/cv/img/aicrop?ratios=%s");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            if (null == config) {
                return WxMpHostConfig.buildUrl(null, this.prefix, this.path);
            }
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private ImgProc(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Comment implements WxMpApiUrl
    {
        OPEN("https://api.weixin.qq.com", "/cgi-bin/comment/open"),
        CLOSE("https://api.weixin.qq.com", "/cgi-bin/comment/close"),
        LIST("https://api.weixin.qq.com", "/cgi-bin/comment/list"),
        MARK_ELECT("https://api.weixin.qq.com", "/cgi-bin/comment/markelect"),
        UNMARK_ELECT("https://api.weixin.qq.com", "/cgi-bin/comment/unmarkelect"),
        DELETE("https://api.weixin.qq.com", "/cgi-bin/comment/delete"),
        REPLY_ADD("https://api.weixin.qq.com", "/cgi-bin/comment/reply/add"),
        REPLY_DELETE("https://api.weixin.qq.com", "/cgi-bin/comment/reply/delete");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Comment(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum User implements WxMpApiUrl
    {
        USER_INFO_BATCH_GET_URL("https://api.weixin.qq.com", "/cgi-bin/user/info/batchget"),
        USER_GET_URL("https://api.weixin.qq.com", "/cgi-bin/user/get"),
        USER_INFO_URL("https://api.weixin.qq.com", "/cgi-bin/user/info"),
        USER_INFO_UPDATE_REMARK_URL("https://api.weixin.qq.com", "/cgi-bin/user/info/updateremark"),
        USER_CHANGE_OPENID_URL("https://api.weixin.qq.com", "/cgi-bin/changeopenid");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private User(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Store implements WxMpApiUrl
    {
        POI_GET_WX_CATEGORY_URL("https://api.weixin.qq.com", "/cgi-bin/poi/getwxcategory"),
        POI_UPDATE_URL("https://api.weixin.qq.com", "/cgi-bin/poi/updatepoi"),
        POI_LIST_URL("https://api.weixin.qq.com", "/cgi-bin/poi/getpoilist"),
        POI_DEL_URL("https://api.weixin.qq.com", "/cgi-bin/poi/delpoi"),
        POI_GET_URL("https://api.weixin.qq.com", "/cgi-bin/poi/getpoi"),
        POI_ADD_URL("https://api.weixin.qq.com", "/cgi-bin/poi/addpoi");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Store(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum MemberCard implements WxMpApiUrl
    {
        MEMBER_CARD_CREATE("https://api.weixin.qq.com", "/card/create"),
        MEMBER_CARD_ACTIVATE("https://api.weixin.qq.com", "/card/membercard/activate"),
        MEMBER_CARD_USER_INFO_GET("https://api.weixin.qq.com", "/card/membercard/userinfo/get"),
        MEMBER_CARD_UPDATE_USER("https://api.weixin.qq.com", "/card/membercard/updateuser"),
        MEMBER_CARD_ACTIVATE_USER_FORM("https://api.weixin.qq.com", "/card/membercard/activateuserform/set"),
        MEMBER_CARD_ACTIVATE_URL("https://api.weixin.qq.com", "/card/membercard/activate/geturl"),
        MEMBER_CARD_UPDATE("https://api.weixin.qq.com", "/card/update"),
        MEMBER_CARD_ACTIVATE_TEMP_INFO("https://api.weixin.qq.com", "/card/membercard/activatetempinfo/get");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private MemberCard(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Material implements WxMpApiUrl
    {
        MEDIA_GET_URL("https://api.weixin.qq.com", "/cgi-bin/media/get"),
        JSSDK_MEDIA_GET_URL("https://api.weixin.qq.com", "/cgi-bin/media/get/jssdk"),
        MEDIA_UPLOAD_URL("https://api.weixin.qq.com", "/cgi-bin/media/upload?type=%s"),
        IMG_UPLOAD_URL("https://api.weixin.qq.com", "/cgi-bin/media/uploadimg"),
        MATERIAL_ADD_URL("https://api.weixin.qq.com", "/cgi-bin/material/add_material?type=%s"),
        NEWS_ADD_URL("https://api.weixin.qq.com", "/cgi-bin/material/add_news"),
        MATERIAL_GET_URL("https://api.weixin.qq.com", "/cgi-bin/material/get_material"),
        NEWS_UPDATE_URL("https://api.weixin.qq.com", "/cgi-bin/material/update_news"),
        MATERIAL_DEL_URL("https://api.weixin.qq.com", "/cgi-bin/material/del_material"),
        MATERIAL_GET_COUNT_URL("https://api.weixin.qq.com", "/cgi-bin/material/get_materialcount"),
        MATERIAL_BATCHGET_URL("https://api.weixin.qq.com", "/cgi-bin/material/batchget_material");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Material(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum MassMessage implements WxMpApiUrl
    {
        MEDIA_UPLOAD_NEWS_URL("https://api.weixin.qq.com", "/cgi-bin/media/uploadnews"),
        MEDIA_UPLOAD_VIDEO_URL("https://api.weixin.qq.com", "/cgi-bin/media/uploadvideo"),
        MESSAGE_MASS_SENDALL_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/sendall"),
        MESSAGE_MASS_SEND_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/send"),
        MESSAGE_MASS_PREVIEW_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/preview"),
        MESSAGE_MASS_DELETE_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/delete"),
        MESSAGE_MASS_SPEED_GET_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/speed/get"),
        MESSAGE_MASS_SPEED_SET_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/speed/set"),
        MESSAGE_MASS_GET_URL("https://api.weixin.qq.com", "/cgi-bin/message/mass/get");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private MassMessage(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Kefu implements WxMpApiUrl
    {
        MESSAGE_CUSTOM_SEND("https://api.weixin.qq.com", "/cgi-bin/message/custom/send"),
        GET_KF_LIST("https://api.weixin.qq.com", "/cgi-bin/customservice/getkflist"),
        GET_ONLINE_KF_LIST("https://api.weixin.qq.com", "/cgi-bin/customservice/getonlinekflist"),
        KFACCOUNT_ADD("https://api.weixin.qq.com", "/customservice/kfaccount/add"),
        KFACCOUNT_UPDATE("https://api.weixin.qq.com", "/customservice/kfaccount/update"),
        KFACCOUNT_INVITE_WORKER("https://api.weixin.qq.com", "/customservice/kfaccount/inviteworker"),
        KFACCOUNT_UPLOAD_HEAD_IMG("https://api.weixin.qq.com", "/customservice/kfaccount/uploadheadimg?kf_account=%s"),
        KFACCOUNT_DEL("https://api.weixin.qq.com", "/customservice/kfaccount/del?kf_account=%s"),
        KFSESSION_CREATE("https://api.weixin.qq.com", "/customservice/kfsession/create"),
        KFSESSION_CLOSE("https://api.weixin.qq.com", "/customservice/kfsession/close"),
        KFSESSION_GET_SESSION("https://api.weixin.qq.com", "/customservice/kfsession/getsession?openid=%s"),
        KFSESSION_GET_SESSION_LIST("https://api.weixin.qq.com", "/customservice/kfsession/getsessionlist?kf_account=%s"),
        KFSESSION_GET_WAIT_CASE("https://api.weixin.qq.com", "/customservice/kfsession/getwaitcase"),
        MSG_RECORD_LIST("https://api.weixin.qq.com", "/customservice/msgrecord/getmsglist"),
        CUSTOM_TYPING("https://api.weixin.qq.com", "/cgi-bin/message/custom/typing");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Kefu(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum DataCube implements WxMpApiUrl
    {
        GET_USER_SUMMARY("https://api.weixin.qq.com", "/datacube/getusersummary"),
        GET_USER_CUMULATE("https://api.weixin.qq.com", "/datacube/getusercumulate"),
        GET_ARTICLE_SUMMARY("https://api.weixin.qq.com", "/datacube/getarticlesummary"),
        GET_ARTICLE_TOTAL("https://api.weixin.qq.com", "/datacube/getarticletotal"),
        GET_USER_READ("https://api.weixin.qq.com", "/datacube/getuserread"),
        GET_USER_READ_HOUR("https://api.weixin.qq.com", "/datacube/getuserreadhour"),
        GET_USER_SHARE("https://api.weixin.qq.com", "/datacube/getusershare"),
        GET_USER_SHARE_HOUR("https://api.weixin.qq.com", "/datacube/getusersharehour"),
        GET_UPSTREAM_MSG("https://api.weixin.qq.com", "/datacube/getupstreammsg"),
        GET_UPSTREAM_MSG_HOUR("https://api.weixin.qq.com", "/datacube/getupstreammsghour"),
        GET_UPSTREAM_MSG_WEEK("https://api.weixin.qq.com", "/datacube/getupstreammsgweek"),
        GET_UPSTREAM_MSG_MONTH("https://api.weixin.qq.com", "/datacube/getupstreammsgmonth"),
        GET_UPSTREAM_MSG_DIST("https://api.weixin.qq.com", "/datacube/getupstreammsgdist"),
        GET_UPSTREAM_MSG_DIST_WEEK("https://api.weixin.qq.com", "/datacube/getupstreammsgdistweek"),
        GET_UPSTREAM_MSG_DIST_MONTH("https://api.weixin.qq.com", "/datacube/getupstreammsgdistmonth"),
        GET_INTERFACE_SUMMARY("https://api.weixin.qq.com", "/datacube/getinterfacesummary"),
        GET_INTERFACE_SUMMARY_HOUR("https://api.weixin.qq.com", "/datacube/getinterfacesummaryhour");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private DataCube(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Card implements WxMpApiUrl
    {
        CARD_CREATE("https://api.weixin.qq.com", "/card/create"),
        CARD_GET("https://api.weixin.qq.com", "/card/get"),
        CARD_GET_TICKET("https://api.weixin.qq.com", "/cgi-bin/ticket/getticket?type=wx_card"),
        CARD_CODE_DECRYPT("https://api.weixin.qq.com", "/card/code/decrypt"),
        CARD_CODE_GET("https://api.weixin.qq.com", "/card/code/get"),
        CARD_CODE_CONSUME("https://api.weixin.qq.com", "/card/code/consume"),
        CARD_CODE_MARK("https://api.weixin.qq.com", "/card/code/mark"),
        CARD_TEST_WHITELIST("https://api.weixin.qq.com", "/card/testwhitelist/set"),
        CARD_QRCODE_CREATE("https://api.weixin.qq.com", "/card/qrcode/create"),
        CARD_LANDING_PAGE_CREATE("https://api.weixin.qq.com", "/card/landingpage/create"),
        CARD_CODE_UNAVAILABLE("https://api.weixin.qq.com", "/card/code/unavailable"),
        CARD_DELETE("https://api.weixin.qq.com", "/card/delete"),
        CARD_CODE_DEPOSIT("https://api.weixin.qq.com", "/card/code/deposit"),
        CARD_CODE_DEPOSIT_COUNT("https://api.weixin.qq.com", "/card/code/getdepositcount"),
        CARD_CODE_CHECKCODE("https://api.weixin.qq.com", "/card/code/checkcode"),
        CARD_MPNEWS_GETHTML("https://api.weixin.qq.com", "/card/mpnews/gethtml"),
        CARD_MODIFY_STOCK("https://api.weixin.qq.com", "/card/modifystock"),
        CARD_CODE_UPDATE("https://api.weixin.qq.com", "/card/code/update"),
        CARD_PAYCELL_SET("https://api.weixin.qq.com", "/card/paycell/set"),
        CARD_SELF_CONSUME_CELL_SET("https://api.weixin.qq.com", "/card/selfconsumecell/set"),
        CARD_USER_CARD_LIST("https://api.weixin.qq.com", "/card/user/getcardlist");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Card(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Ocr implements WxMpApiUrl
    {
        IDCARD("https://api.weixin.qq.com", "/cv/ocr/idcard?img_url=%s"),
        FILEIDCARD("https://api.weixin.qq.com", "/cv/ocr/idcard"),
        BANK_CARD("https://api.weixin.qq.com", "/cv/ocr/bankcard?img_url=%s"),
        FILE_BANK_CARD("https://api.weixin.qq.com", "/cv/ocr/bankcard"),
        DRIVING("https://api.weixin.qq.com", "/cv/ocr/driving?img_url=%s"),
        FILE_DRIVING("https://api.weixin.qq.com", "/cv/ocr/driving"),
        DRIVING_LICENSE("https://api.weixin.qq.com", "/cv/ocr/drivinglicense?img_url=%s"),
        FILE_DRIVING_LICENSE("https://api.weixin.qq.com", "/cv/ocr/drivinglicense"),
        BIZ_LICENSE("https://api.weixin.qq.com", "/cv/ocr/bizlicense?img_url=%s"),
        FILE_BIZ_LICENSE("https://api.weixin.qq.com", "/cv/ocr/bizlicense"),
        COMM("https://api.weixin.qq.com", "/cv/ocr/comm?img_url=%s"),
        FILE_COMM("https://api.weixin.qq.com", "/cv/ocr/comm");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            if (config == null) {
                return WxMpHostConfig.buildUrl(null, this.prefix, this.path);
            }
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Ocr(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum AiOpen implements WxMpApiUrl
    {
        TRANSLATE_URL("https://api.weixin.qq.com", "/cgi-bin/media/voice/translatecontent?lfrom=%s&lto=%s"),
        VOICE_UPLOAD_URL("https://api.weixin.qq.com", "/cgi-bin/media/voice/addvoicetorecofortext?format=%s&voice_id=%s&lang=%s"),
        VOICE_QUERY_RESULT_URL("https://api.weixin.qq.com", "/cgi-bin/media/voice/queryrecoresultfortext");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private AiOpen(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Wifi implements WxMpApiUrl
    {
        BIZWIFI_SHOP_LIST("https://api.weixin.qq.com", "/bizwifi/shop/list"),
        BIZWIFI_SHOP_GET("https://api.weixin.qq.com", "/bizwifi/shop/get"),
        BIZWIFI_SHOP_UPDATE("https://api.weixin.qq.com", "/bizwifi/shop/update");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Wifi(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum UserTag implements WxMpApiUrl
    {
        TAGS_CREATE("https://api.weixin.qq.com", "/cgi-bin/tags/create"),
        TAGS_GET("https://api.weixin.qq.com", "/cgi-bin/tags/get"),
        TAGS_UPDATE("https://api.weixin.qq.com", "/cgi-bin/tags/update"),
        TAGS_DELETE("https://api.weixin.qq.com", "/cgi-bin/tags/delete"),
        TAG_GET("https://api.weixin.qq.com", "/cgi-bin/user/tag/get"),
        TAGS_MEMBERS_BATCHTAGGING("https://api.weixin.qq.com", "/cgi-bin/tags/members/batchtagging"),
        TAGS_MEMBERS_BATCHUNTAGGING("https://api.weixin.qq.com", "/cgi-bin/tags/members/batchuntagging"),
        TAGS_GETIDLIST("https://api.weixin.qq.com", "/cgi-bin/tags/getidlist");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private UserTag(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum UserBlacklist implements WxMpApiUrl
    {
        GETBLACKLIST("https://api.weixin.qq.com", "/cgi-bin/tags/members/getblacklist"),
        BATCHBLACKLIST("https://api.weixin.qq.com", "/cgi-bin/tags/members/batchblacklist"),
        BATCHUNBLACKLIST("https://api.weixin.qq.com", "/cgi-bin/tags/members/batchunblacklist");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private UserBlacklist(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum TemplateMsg implements WxMpApiUrl
    {
        MESSAGE_TEMPLATE_SEND("https://api.weixin.qq.com", "/cgi-bin/message/template/send"),
        TEMPLATE_API_SET_INDUSTRY("https://api.weixin.qq.com", "/cgi-bin/template/api_set_industry"),
        TEMPLATE_GET_INDUSTRY("https://api.weixin.qq.com", "/cgi-bin/template/get_industry"),
        TEMPLATE_API_ADD_TEMPLATE("https://api.weixin.qq.com", "/cgi-bin/template/api_add_template"),
        TEMPLATE_GET_ALL_PRIVATE_TEMPLATE("https://api.weixin.qq.com", "/cgi-bin/template/get_all_private_template"),
        TEMPLATE_DEL_PRIVATE_TEMPLATE("https://api.weixin.qq.com", "/cgi-bin/template/del_private_template");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private TemplateMsg(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum SubscribeMsg implements WxMpApiUrl
    {
        SUBSCRIBE_MESSAGE_AUTHORIZE_URL("https://mp.weixin.qq.com", "/mp/subscribemsg?action=get_confirm&appid=%s&scene=%d&template_id=%s&redirect_url=%s&reserved=%s#wechat_redirect"),
        SEND_MESSAGE_URL("https://api.weixin.qq.com", "/cgi-bin/message/template/subscribe");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private SubscribeMsg(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum ShakeAround implements WxMpApiUrl
    {
        SHAKEAROUND_USER_GETSHAKEINFO("https://api.weixin.qq.com", "/shakearound/user/getshakeinfo"),
        SHAKEAROUND_PAGE_ADD("https://api.weixin.qq.com", "/shakearound/page/add"),
        SHAKEAROUND_DEVICE_BINDPAGE("https://api.weixin.qq.com", "/shakearound/device/bindpage"),
        SHAKEAROUND_RELATION_SEARCH("https://api.weixin.qq.com", "/shakearound/relation/search");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private ShakeAround(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Qrcode implements WxMpApiUrl
    {
        QRCODE_CREATE("https://api.weixin.qq.com", "/cgi-bin/qrcode/create"),
        SHOW_QRCODE("https://mp.weixin.qq.com", "/cgi-bin/showqrcode"),
        SHOW_QRCODE_WITH_TICKET("https://mp.weixin.qq.com", "/cgi-bin/showqrcode?ticket=%s");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Qrcode(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Menu implements WxMpApiUrl
    {
        GET_CURRENT_SELFMENU_INFO("https://api.weixin.qq.com", "/cgi-bin/get_current_selfmenu_info"),
        MENU_TRYMATCH("https://api.weixin.qq.com", "/cgi-bin/menu/trymatch"),
        MENU_GET("https://api.weixin.qq.com", "/cgi-bin/menu/get"),
        MENU_DELCONDITIONAL("https://api.weixin.qq.com", "/cgi-bin/menu/delconditional"),
        MENU_DELETE("https://api.weixin.qq.com", "/cgi-bin/menu/delete"),
        MENU_CREATE("https://api.weixin.qq.com", "/cgi-bin/menu/create"),
        MENU_ADDCONDITIONAL("https://api.weixin.qq.com", "/cgi-bin/menu/addconditional");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Menu(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Marketing implements WxMpApiUrl
    {
        USER_ACTION_SETS_ADD("https://api.weixin.qq.com", "/marketing/user_action_sets/add?version=v1.0"),
        USER_ACTION_SETS_GET("https://api.weixin.qq.com", "/marketing/user_action_sets/get"),
        USER_ACTIONS_ADD("https://api.weixin.qq.com", "/marketing/user_actions/add?version=v1.0"),
        WECHAT_AD_LEADS_GET("https://api.weixin.qq.com", "/marketing/wechat_ad_leads/get");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Marketing(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Other implements WxMpApiUrl
    {
        GET_ACCESS_TOKEN_URL("https://api.weixin.qq.com", "/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s"),
        GET_TICKET_URL("https://api.weixin.qq.com", "/cgi-bin/ticket/getticket?type="),
        SHORTURL_API_URL("https://api.weixin.qq.com", "/cgi-bin/shorturl"),
        SEMANTIC_SEMPROXY_SEARCH_URL("https://api.weixin.qq.com", "/semantic/semproxy/search"),
        OAUTH2_ACCESS_TOKEN_URL("https://api.weixin.qq.com", "/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code"),
        OAUTH2_REFRESH_TOKEN_URL("https://api.weixin.qq.com", "/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s"),
        OAUTH2_USERINFO_URL("https://api.weixin.qq.com", "/sns/userinfo?access_token=%s&openid=%s&lang=%s"),
        OAUTH2_VALIDATE_TOKEN_URL("https://api.weixin.qq.com", "/sns/auth?access_token=%s&openid=%s"),
        GET_CALLBACK_IP_URL("https://api.weixin.qq.com", "/cgi-bin/getcallbackip"),
        NETCHECK_URL("https://api.weixin.qq.com", "/cgi-bin/callback/check"),
        QRCONNECT_URL("https://open.weixin.qq.com", "/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect"),
        CONNECT_OAUTH2_AUTHORIZE_URL("https://open.weixin.qq.com", "/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s&connect_redirect=1#wechat_redirect"),
        GET_CURRENT_AUTOREPLY_INFO_URL("https://api.weixin.qq.com", "/cgi-bin/get_current_autoreply_info"),
        CLEAR_QUOTA_URL("https://api.weixin.qq.com", "/cgi-bin/clear_quota");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Other(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }

    public static enum Device implements WxMpApiUrl
    {
        DEVICE_GET_BIND_DEVICE("https://api.weixin.qq.com", "/device/get_bind_device"),
        DEVICE_GET_OPENID("https://api.weixin.qq.com", "/device/get_openid"),
        DEVICE_COMPEL_UNBIND("https://api.weixin.qq.com", "/device/compel_unbind?"),
        DEVICE_UNBIND("https://api.weixin.qq.com", "/device/unbind?"),
        DEVICE_COMPEL_BIND("https://api.weixin.qq.com", "/device/compel_bind"),
        DEVICE_BIND("https://api.weixin.qq.com", "/device/bind"),
        DEVICE_AUTHORIZE_DEVICE("https://api.weixin.qq.com", "/device/authorize_device"),
        DEVICE_GETQRCODE("https://api.weixin.qq.com", "/device/getqrcode"),
        DEVICE_TRANSMSG("https://api.weixin.qq.com", "/device/transmsg");

        private String prefix;
        private String path;

        @Override
        public String getUrl(WxMpConfigStorage config) {
            return WxMpHostConfig.buildUrl(config.getHostConfig(), this.prefix, this.path);
        }

        private Device(String prefix, String path) {
            this.prefix = prefix;
            this.path = path;
        }
    }
}

