/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultExceptionResolver
implements ExceptionResolver {
    private static final Logger LOGGER = Logger.getLogger(DefaultExceptionResolver.class.getName());
    public static final DefaultExceptionResolver INSTANCE = new DefaultExceptionResolver();

    @Override
    public Throwable resolveException(ObjectNode response) {
        ObjectNode errorObject = (ObjectNode)ObjectNode.class.cast(response.get("error"));
        if (!errorObject.has("data") || errorObject.get("data").isNull() || !errorObject.get("data").isObject()) {
            return this.createJsonRpcClientException(errorObject);
        }
        ObjectNode dataObject = (ObjectNode)ObjectNode.class.cast(errorObject.get("data"));
        if (!dataObject.has("exceptionTypeName") || dataObject.get("exceptionTypeName") == null || dataObject.get("exceptionTypeName").isNull() || !dataObject.get("exceptionTypeName").isTextual()) {
            return this.createJsonRpcClientException(errorObject);
        }
        String exceptionTypeName = dataObject.get("exceptionTypeName").asText();
        String message = dataObject.has("message") && dataObject.get("message").isTextual() ? dataObject.get("message").asText() : null;
        Throwable ret = null;
        try {
            ret = this.createThrowable(exceptionTypeName, message);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to create throwable", e);
        }
        if (ret == null) {
            ret = this.createJsonRpcClientException(errorObject);
        }
        return ret;
    }

    private JsonRpcClientException createJsonRpcClientException(ObjectNode errorObject) {
        int code = errorObject.has("code") ? errorObject.get("code").asInt() : 0;
        return new JsonRpcClientException(code, errorObject.get("message").asText(), errorObject.get("data"));
    }

    private Throwable createThrowable(String typeName, String message) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(typeName);
        }
        catch (Exception e) {
            LOGGER.warning("Unable to load Throwable class " + typeName);
            return null;
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            LOGGER.warning("Type does not inherit from Throwable" + clazz.getName());
            return null;
        }
        Class<?> tClazz = clazz;
        Constructor<?> defaultCtr = null;
        Constructor<?> messageCtr = null;
        try {
            defaultCtr = tClazz.getConstructor(new Class[0]);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            messageCtr = tClazz.getConstructor(String.class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (message != null && messageCtr != null) {
            return (Throwable)messageCtr.newInstance(message);
        }
        if (message != null && defaultCtr != null) {
            LOGGER.warning("Unable to invoke message constructor for " + clazz.getName());
            return (Throwable)defaultCtr.newInstance(new Object[0]);
        }
        if (message == null && defaultCtr != null) {
            return (Throwable)defaultCtr.newInstance(new Object[0]);
        }
        if (message == null && messageCtr != null) {
            LOGGER.warning("Passing null message to message constructor for " + clazz.getName());
            return (Throwable)messageCtr.newInstance(new Object[]{null});
        }
        LOGGER.warning("Unable to find a suitable constructor for " + clazz.getName());
        return null;
    }
}

