/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.googlecode.jsonrpc4j.DefaultExceptionResolver;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import com.googlecode.jsonrpc4j.JsonRpcClientException;
import com.googlecode.jsonrpc4j.NoCloseOutputStream;
import com.googlecode.jsonrpc4j.ReadContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonRpcClient {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcClient.class.getName());
    private static final String JSON_RPC_VERSION = "2.0";
    private final ObjectMapper mapper;
    private final Random random;
    private RequestListener requestListener;
    private ExceptionResolver exceptionResolver = DefaultExceptionResolver.INSTANCE;

    public JsonRpcClient(ObjectMapper mapper) {
        this.mapper = mapper;
        this.random = new Random(System.currentTimeMillis());
    }

    public JsonRpcClient() {
        this(new ObjectMapper());
    }

    public void setRequestListener(RequestListener requestListener) {
        this.requestListener = requestListener;
    }

    public Object invokeAndReadResponse(String methodName, Object argument, Type returnType, OutputStream ops, InputStream ips) throws Throwable {
        return this.invokeAndReadResponse(methodName, argument, returnType, ops, ips, this.random.nextLong() + "");
    }

    public <T> T invokeAndReadResponse(String methodName, Object argument, Class<T> clazz, OutputStream ops, InputStream ips) throws Throwable {
        return (T)this.invokeAndReadResponse(methodName, argument, (Type)Type.class.cast(clazz), ops, ips);
    }

    public Object invokeAndReadResponse(String methodName, Object argument, Type returnType, OutputStream ops, InputStream ips, String id) throws Throwable {
        this.invoke(methodName, argument, ops, id);
        return this.readResponse(returnType, ips, id);
    }

    public <T> T invokeAndReadResponse(String methodName, Object argument, Class<T> clazz, OutputStream ops, InputStream ips, String id) throws Throwable {
        return (T)this.invokeAndReadResponse(methodName, argument, (Type)Type.class.cast(clazz), ops, ips, id);
    }

    public void invoke(String methodName, Object argument, OutputStream ops) throws IOException {
        this.invoke(methodName, argument, ops, this.random.nextLong() + "");
    }

    public void invoke(String methodName, Object argument, OutputStream ops, String id) throws IOException {
        this.writeRequest(methodName, argument, ops, id);
        ops.flush();
    }

    public void invokeNotification(String methodName, Object argument, OutputStream ops) throws IOException {
        this.writeRequest(methodName, argument, ops, null);
        ops.flush();
    }

    public <T> T readResponse(Class<T> clazz, InputStream ips) throws Throwable {
        return (T)this.readResponse((Type)clazz, ips);
    }

    public <T> T readResponse(Class<T> clazz, InputStream ips, String id) throws Throwable {
        return (T)this.readResponse((Type)clazz, ips, id);
    }

    public Object readResponse(Type returnType, InputStream ips) throws Throwable {
        return this.readResponse(returnType, ips, null);
    }

    public Object readResponse(Type returnType, InputStream ips, String id) throws Throwable {
        ReadContext ctx = ReadContext.getReadContext(ips, this.mapper);
        ctx.assertReadable();
        JsonNode response = ctx.nextValue();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JSON-PRC Response: {0}", response.toString());
        }
        if (!response.isObject()) {
            throw new JsonRpcClientException(0, "Invalid JSON-RPC response", response);
        }
        ObjectNode jsonObject = (ObjectNode)ObjectNode.class.cast(response);
        if (id != null) {
            while (!jsonObject.has("id") || jsonObject.get("id") == null || !jsonObject.get("id").asText().equals(id)) {
                response = ctx.nextValue();
                if (!response.isObject()) {
                    throw new JsonRpcClientException(0, "Invalid JSON-RPC response", response);
                }
                jsonObject = (ObjectNode)ObjectNode.class.cast(response);
            }
        }
        if (this.requestListener != null) {
            this.requestListener.onBeforeResponseProcessed(this, jsonObject);
        }
        if (jsonObject.has("error") && jsonObject.get("error") != null && !jsonObject.get("error").isNull()) {
            if (this.exceptionResolver == null) {
                throw DefaultExceptionResolver.INSTANCE.resolveException(jsonObject);
            }
            throw this.exceptionResolver.resolveException(jsonObject);
        }
        if (jsonObject.has("result") && !jsonObject.get("result").isNull() && jsonObject.get("result") != null) {
            if (returnType == null) {
                LOGGER.warning("Server returned result but returnType is null");
                return null;
            }
            JsonParser returnJsonParser = this.mapper.treeAsTokens((TreeNode)jsonObject.get("result"));
            JavaType returnJavaType = TypeFactory.defaultInstance().constructType(returnType);
            return this.mapper.readValue(returnJsonParser, returnJavaType);
        }
        return null;
    }

    public void writeRequest(String methodName, Object argument, OutputStream ops, String id) throws IOException {
        this.internalWriteRequest(methodName, argument, ops, id);
    }

    public ObjectNode createRequest(String methodName, Object argument) {
        return this.internalCreateRequest(methodName, argument, "" + this.random.nextLong());
    }

    public ObjectNode createRequest(String methodName, Object argument, String id) {
        return this.internalCreateRequest(methodName, argument, id);
    }

    public void writeNotification(String methodName, Object argument, OutputStream ops) throws IOException {
        this.internalWriteRequest(methodName, argument, ops, null);
    }

    private void internalWriteRequest(String methodName, Object arguments, OutputStream ops, String id) throws IOException {
        ObjectNode request = this.internalCreateRequest(methodName, arguments, id);
        this.writeAndFlushValue(ops, request);
    }

    private ObjectNode internalCreateRequest(String methodName, Object arguments, String id) {
        ObjectNode request = this.mapper.createObjectNode();
        if (id != null) {
            request.put("id", id);
        }
        request.put("jsonrpc", JSON_RPC_VERSION);
        request.put("method", methodName);
        if (arguments != null && arguments.getClass().isArray()) {
            Object[] args = (Object[])Object[].class.cast(arguments);
            if (args.length > 0) {
                ArrayNode paramsNode = new ArrayNode(this.mapper.getNodeFactory());
                for (Object arg : args) {
                    JsonNode argNode = this.mapper.valueToTree(arg);
                    paramsNode.add(argNode);
                }
                request.set("params", (JsonNode)paramsNode);
            }
        } else if (arguments != null && Collection.class.isInstance(arguments)) {
            Collection args = (Collection)Collection.class.cast(arguments);
            if (!args.isEmpty()) {
                ArrayNode paramsNode = new ArrayNode(this.mapper.getNodeFactory());
                for (Object arg : args) {
                    JsonNode argNode = this.mapper.valueToTree(arg);
                    paramsNode.add(argNode);
                }
                request.set("params", (JsonNode)paramsNode);
            }
        } else if (arguments != null && Map.class.isInstance(arguments)) {
            if (!((Map)Map.class.cast(arguments)).isEmpty()) {
                request.set("params", this.mapper.valueToTree(arguments));
            }
        } else if (arguments != null) {
            request.set("params", this.mapper.valueToTree(arguments));
        }
        if (this.requestListener != null) {
            this.requestListener.onBeforeRequestSent(this, request);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JSON-PRC Request: {0}", request.toString());
        }
        return request;
    }

    private void writeAndFlushValue(OutputStream ops, Object value) throws IOException {
        this.mapper.writeValue((OutputStream)new NoCloseOutputStream(ops), value);
        ops.flush();
    }

    protected Object readResponse(Type returnType, ObjectNode jsonObject) throws Throwable {
        return this.readResponse(returnType, jsonObject, null);
    }

    protected Object readResponse(Type returnType, ObjectNode jsonObject, String id) throws Throwable {
        if (!jsonObject.isObject()) {
            throw new JsonRpcClientException(0, "Invalid JSON-RPC response", (JsonNode)jsonObject);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "JSON-PRC Response: {0}", jsonObject.toString());
        }
        if (this.requestListener != null) {
            this.requestListener.onBeforeResponseProcessed(this, jsonObject);
        }
        if (jsonObject.has("error") && jsonObject.get("error") != null && !jsonObject.get("error").isNull()) {
            if (this.exceptionResolver == null) {
                throw DefaultExceptionResolver.INSTANCE.resolveException(jsonObject);
            }
            throw this.exceptionResolver.resolveException(jsonObject);
        }
        if (jsonObject.has("result") && !jsonObject.get("result").isNull() && jsonObject.get("result") != null) {
            if (returnType == null) {
                LOGGER.warning("Server returned result but returnType is null");
                return null;
            }
            JsonParser returnJsonParser = this.mapper.treeAsTokens((TreeNode)jsonObject.get("result"));
            JavaType returnJavaType = TypeFactory.defaultInstance().constructType(returnType);
            return this.mapper.readValue(returnJsonParser, returnJavaType);
        }
        return null;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public void setExceptionResolver(ExceptionResolver exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }

    public static interface RequestListener {
        public void onBeforeRequestSent(JsonRpcClient var1, ObjectNode var2);

        public void onBeforeResponseProcessed(JsonRpcClient var1, ObjectNode var2);
    }
}

