/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JsonRpcMultiServer
extends JsonRpcServer {
    public static final char DEFAULT_SEPARATOR = '.';
    private static final Logger LOGGER = Logger.getLogger(JsonRpcMultiServer.class.getName());
    private Map<String, Object> handlerMap;
    private Map<String, Class<?>> interfaceMap;
    private char separator = (char)46;

    public JsonRpcMultiServer() {
        this(new ObjectMapper());
    }

    public JsonRpcMultiServer(ObjectMapper mapper) {
        super(mapper, (Object)null);
        this.handlerMap = new HashMap<String, Object>();
        this.interfaceMap = new HashMap();
    }

    public JsonRpcMultiServer addService(String name, Object handler) {
        return this.addService(name, handler, null);
    }

    public JsonRpcMultiServer addService(String name, Object handler, Class<?> remoteInterface) {
        this.handlerMap.put(name, handler);
        if (remoteInterface != null) {
            this.interfaceMap.put(name, remoteInterface);
        }
        return this;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    @Override
    protected Class<?>[] getHandlerInterfaces(String serviceName) {
        Class<?> remoteInterface = this.interfaceMap.get(serviceName);
        if (remoteInterface != null) {
            return new Class[]{remoteInterface};
        }
        if (Proxy.isProxyClass(this.getHandler(serviceName).getClass())) {
            return this.getHandler(serviceName).getClass().getInterfaces();
        }
        return new Class[]{this.getHandler(serviceName).getClass()};
    }

    @Override
    protected Object getHandler(String serviceName) {
        Object handler = this.handlerMap.get(serviceName);
        if (handler == null) {
            LOGGER.log(Level.SEVERE, "Service '" + serviceName + "' is not registered in this multi-server");
            throw new RuntimeException("Service '" + serviceName + "' does not exist");
        }
        return handler;
    }

    @Override
    protected String getServiceName(JsonNode methodNode) {
        int ndx;
        String methodName;
        String string = methodName = methodNode != null && !methodNode.isNull() ? methodNode.asText() : null;
        if (methodName != null && (ndx = methodName.indexOf(this.separator)) > 0) {
            return methodName.substring(0, ndx);
        }
        return methodName;
    }

    @Override
    protected String getMethodName(JsonNode methodNode) {
        int ndx;
        String methodName;
        String string = methodName = methodNode != null && !methodNode.isNull() ? methodNode.asText() : null;
        if (methodName != null && (ndx = methodName.indexOf(this.separator)) > 0) {
            return methodName.substring(ndx + 1);
        }
        return methodName;
    }
}

