/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcBasicServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsonRpcServer
extends JsonRpcBasicServer {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcServer.class.getName());

    public JsonRpcServer(ObjectMapper mapper, Object handler, Class<?> remoteInterface) {
        super(mapper, handler, remoteInterface);
    }

    public JsonRpcServer(ObjectMapper mapper, Object handler) {
        super(mapper, handler, null);
    }

    public JsonRpcServer(Object handler, Class<?> remoteInterface) {
        super(new ObjectMapper(), handler, remoteInterface);
    }

    public JsonRpcServer(Object handler) {
        super(new ObjectMapper(), handler, null);
    }

    public void handle(ResourceRequest request, ResourceResponse response) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing ResourceRequest " + request.getMethod());
        }
        response.setContentType("application/json-rpc");
        InputStream input = null;
        OutputStream output = response.getPortletOutputStream();
        if (request.getMethod().equals("POST")) {
            input = request.getPortletInputStream();
        } else if (request.getMethod().equals("GET")) {
            input = JsonRpcServer.createInputStream(request.getParameter("method"), request.getParameter("id"), request.getParameter("params"));
        } else {
            throw new IOException("Invalid request method, only POST and GET is supported");
        }
        this.handle(input, output);
        output.flush();
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing HttpServletRequest " + request.getMethod());
        }
        response.setContentType("application/json-rpc");
        Object input = null;
        ServletOutputStream output = response.getOutputStream();
        if (request.getMethod().equals("POST")) {
            input = request.getInputStream();
        } else if (request.getMethod().equals("GET")) {
            input = JsonRpcServer.createInputStream(request.getParameter("method"), request.getParameter("id"), request.getParameter("params"));
        } else {
            throw new IOException("Invalid request method, only POST and GET is supported");
        }
        int result = this.handle((InputStream)input, (OutputStream)output);
        if (result != 0) {
            if (result == -32700 || result == -32602 || result == -32603 || result <= -32000 && result >= -32099) {
                response.setStatus(500);
            } else if (result == -32600) {
                response.setStatus(400);
            } else if (result == -32601) {
                response.setStatus(404);
            }
        }
        output.flush();
    }
}

