/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcMethod;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProxyUtil {
    private static final Logger LOGGER = Logger.getLogger(ProxyUtil.class.getName());

    public static Object createCompositeServiceProxy(ClassLoader classLoader, Object[] services, boolean allowMultipleInheritance) {
        return ProxyUtil.createCompositeServiceProxy(classLoader, services, null, allowMultipleInheritance);
    }

    /*
     * WARNING - void declaration
     */
    public static Object createCompositeServiceProxy(ClassLoader classLoader, Object[] services, Class<?>[] serviceInterfaces, boolean allowMultipleInheritance) {
        HashSet interfaces = new HashSet();
        if (serviceInterfaces != null) {
            interfaces.addAll(Arrays.asList(serviceInterfaces));
        } else {
            void var7_9;
            Object[] objectArray = services;
            int n = objectArray.length;
            boolean bl = false;
            while (var7_9 < n) {
                Object o = objectArray[var7_9];
                interfaces.addAll(Arrays.asList(o.getClass().getInterfaces()));
                ++var7_9;
            }
        }
        final HashMap<Class, Object> serviceMap = new HashMap<Class, Object>();
        for (Class clazz : interfaces) {
            if (serviceMap.containsKey(clazz) && allowMultipleInheritance) continue;
            if (serviceMap.containsKey(clazz)) {
                throw new IllegalArgumentException("Multiple inheritance not allowed " + clazz.getName());
            }
            for (Object o : services) {
                if (!clazz.isInstance(o)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Using {0} for {1}", new Object[]{o.getClass().getName(), clazz.getName()});
                }
                serviceMap.put(clazz, o);
                break;
            }
            if (serviceMap.containsKey(clazz)) continue;
            throw new IllegalArgumentException("None of the provided services implement " + clazz.getName());
        }
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[0]), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> clazz = method.getDeclaringClass();
                if (clazz == Object.class) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args);
                }
                return method.invoke(serviceMap.get(clazz), args);
            }
        });
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, JsonRpcClient client, Socket socket) throws IOException {
        return ProxyUtil.createClientProxy(classLoader, proxyInterface, false, client, socket.getInputStream(), socket.getOutputStream());
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, final boolean useNamedParams, final JsonRpcClient client, final InputStream ips, final OutputStream ops) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args);
                }
                Object arguments = ReflectionUtil.parseArguments(method, args, useNamedParams);
                String methodName = method.getName();
                JsonRpcMethod methodAnnotation = method.getAnnotation(JsonRpcMethod.class);
                if (methodAnnotation != null && methodAnnotation.value() != null) {
                    methodName = methodAnnotation.value();
                }
                return client.invokeAndReadResponse(methodName, arguments, method.getGenericReturnType(), ops, ips);
            }
        });
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, final boolean useNamedParams, final IJsonRpcClient client, final Map<String, String> extraHeaders) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return ProxyUtil.proxyObjectMethods(method, proxy, args);
                }
                Object arguments = ReflectionUtil.parseArguments(method, args, useNamedParams);
                String methodName = method.getName();
                JsonRpcMethod methodAnnotation = method.getAnnotation(JsonRpcMethod.class);
                if (methodAnnotation != null && methodAnnotation.value() != null) {
                    methodName = methodAnnotation.value();
                }
                return client.invoke(methodName, arguments, method.getGenericReturnType(), (Map<String, String>)extraHeaders);
            }
        });
    }

    public static <T> T createClientProxy(ClassLoader classLoader, Class<T> proxyInterface, IJsonRpcClient client) {
        return ProxyUtil.createClientProxy(classLoader, proxyInterface, false, client, new HashMap<String, String>());
    }

    private static Object proxyObjectMethods(Method method, Object proxyObject, Object[] args) {
        String name = method.getName();
        if (name.equals("toString")) {
            return proxyObject.getClass().getName() + "@" + System.identityHashCode(proxyObject);
        }
        if (name.equals("hashCode")) {
            return System.identityHashCode(proxyObject);
        }
        if (name.equals("equals")) {
            return proxyObject == args[0];
        }
        throw new RuntimeException(method.getName() + " is not a member of java.lang.Object");
    }
}

