/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcService;
import com.googlecode.jsonrpc4j.spring.JsonProxyFactoryBean;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class AutoJsonRpcClientProxyCreator
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger LOG = Logger.getLogger(AutoJsonRpcClientProxyCreator.class.getName());
    private ApplicationContext applicationContext;
    private String scanPackage;
    private URL baseUrl;
    private ObjectMapper objectMapper;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SimpleMetadataReaderFactory metadataReaderFactory = new SimpleMetadataReaderFactory((ResourceLoader)this.applicationContext);
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        String resolvedPath = this.resolvePackageToScan();
        LOG.fine(String.format("Scanning '%s' for JSON-RPC service interfaces.", resolvedPath));
        try {
            for (Resource resource : this.applicationContext.getResources(resolvedPath)) {
                String jsonRpcPathAnnotation;
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                ClassMetadata classMetadata = metadataReader.getClassMetadata();
                AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
                if (!annotationMetadata.isAnnotated(jsonRpcPathAnnotation = JsonRpcService.class.getName())) continue;
                String className = classMetadata.getClassName();
                String path = (String)annotationMetadata.getAnnotationAttributes(jsonRpcPathAnnotation).get("value");
                boolean useNamedParams = (Boolean)annotationMetadata.getAnnotationAttributes(jsonRpcPathAnnotation).get("useNamedParams");
                LOG.fine(String.format("Found JSON-RPC service to proxy [%s] on path '%s'.", className, path));
                this.registerJsonProxyBean(dlbf, className, path, useNamedParams);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot scan package '%s' for classes.", resolvedPath), e);
        }
    }

    private String resolvePackageToScan() {
        return "classpath:" + ClassUtils.convertClassNameToResourcePath((String)this.scanPackage) + "/**/*.class";
    }

    private void registerJsonProxyBean(DefaultListableBeanFactory dlbf, String className, String path, boolean useNamedParams) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(JsonProxyFactoryBean.class).addPropertyValue("serviceUrl", (Object)this.appendBasePath(path)).addPropertyValue("serviceInterface", (Object)className).addPropertyValue("useNamedParams", (Object)useNamedParams);
        if (this.objectMapper != null) {
            beanDefinitionBuilder.addPropertyValue("objectMapper", (Object)this.objectMapper);
        }
        dlbf.registerBeanDefinition(className + "-clientProxy", (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
    }

    private String appendBasePath(String path) {
        try {
            return new URL(this.baseUrl, path).toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Cannot combine URLs '%s' and '%s' to valid URL.", this.baseUrl, path), e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setScanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

