/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.InvocationListener;
import com.googlecode.jsonrpc4j.JsonRpcService;
import com.googlecode.jsonrpc4j.spring.JsonServiceExporter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.util.ClassUtils;

public class AutoJsonRpcServiceExporter
implements BeanFactoryPostProcessor {
    private static final Logger LOG = Logger.getLogger(AutoJsonRpcServiceExporter.class.getName());
    private static final String PATH_PREFIX = "/";
    private Map<String, String> serviceBeanNames = new HashMap<String, String>();
    private ObjectMapper objectMapper;
    private ErrorResolver errorResolver = null;
    private Boolean registerTraceInterceptor;
    private boolean backwardsComaptible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private Level exceptionLogLevel = Level.WARNING;
    private InvocationListener invocationListener = null;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        this.findServiceBeanDefinitions((ConfigurableListableBeanFactory)dlbf);
        for (Map.Entry<String, String> entry : this.serviceBeanNames.entrySet()) {
            String servicePath = entry.getKey();
            String serviceBeanName = entry.getValue();
            this.registerServiceProxy(dlbf, this.makeUrlPath(servicePath), serviceBeanName);
        }
    }

    private void findServiceBeanDefinitions(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            JsonRpcService jsonRpcPath = (JsonRpcService)beanFactory.findAnnotationOnBean(beanName, JsonRpcService.class);
            if (jsonRpcPath == null) continue;
            String pathValue = jsonRpcPath.value();
            LOG.fine(String.format("Found JSON-RPC path '%s' for bean [%s].", pathValue, beanName));
            if (this.serviceBeanNames.containsKey(pathValue)) {
                String otherBeanName = this.serviceBeanNames.get(pathValue);
                LOG.warning(String.format("Duplicate JSON-RPC path specification: found %s on both [%s] and [%s].", pathValue, beanName, otherBeanName));
            }
            this.serviceBeanNames.put(pathValue, beanName);
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            this.findServiceBeanDefinitions((ConfigurableListableBeanFactory)parentBeanFactory);
        }
    }

    private String makeUrlPath(String servicePath) {
        return PATH_PREFIX.concat(servicePath);
    }

    private void registerServiceProxy(DefaultListableBeanFactory dlbf, String servicePath, String serviceBeanName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JsonServiceExporter.class).addPropertyReference("service", serviceBeanName);
        BeanDefinition serviceBeanDefinition = this.findBeanDefintion((ConfigurableListableBeanFactory)dlbf, serviceBeanName);
        for (Class<?> iface : this.getBeanInterfaces(serviceBeanDefinition, dlbf.getBeanClassLoader())) {
            if (!iface.isAnnotationPresent(JsonRpcService.class)) continue;
            String serviceInterface = iface.getName();
            LOG.fine(String.format("Registering interface '%s' for JSON-RPC bean [%s].", serviceInterface, serviceBeanName));
            builder.addPropertyValue("serviceInterface", (Object)serviceInterface);
            break;
        }
        if (this.objectMapper != null) {
            builder.addPropertyValue("objectMapper", (Object)this.objectMapper);
        }
        if (this.errorResolver != null) {
            builder.addPropertyValue("errorResolver", (Object)this.errorResolver);
        }
        if (this.invocationListener != null) {
            builder.addPropertyValue("invocationListener", (Object)this.invocationListener);
        }
        if (this.registerTraceInterceptor != null) {
            builder.addPropertyValue("registerTraceInterceptor", (Object)this.registerTraceInterceptor);
        }
        builder.addPropertyValue("backwardsComaptible", (Object)this.backwardsComaptible);
        builder.addPropertyValue("rethrowExceptions", (Object)this.rethrowExceptions);
        builder.addPropertyValue("allowExtraParams", (Object)this.allowExtraParams);
        builder.addPropertyValue("allowLessParams", (Object)this.allowLessParams);
        builder.addPropertyValue("exceptionLogLevel", (Object)this.exceptionLogLevel);
        dlbf.registerBeanDefinition(servicePath, (BeanDefinition)builder.getBeanDefinition());
    }

    private BeanDefinition findBeanDefintion(ConfigurableListableBeanFactory beanFactory, String serviceBeanName) {
        if (beanFactory.containsLocalBean(serviceBeanName)) {
            return beanFactory.getBeanDefinition(serviceBeanName);
        }
        BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
        if (parentBeanFactory != null && ConfigurableListableBeanFactory.class.isInstance(parentBeanFactory)) {
            return this.findBeanDefintion((ConfigurableListableBeanFactory)parentBeanFactory, serviceBeanName);
        }
        throw new RuntimeException(String.format("Bean with name '%s' can no longer be found.", serviceBeanName));
    }

    private Class<?>[] getBeanInterfaces(BeanDefinition serviceBeanDefinition, ClassLoader beanClassLoader) {
        String beanClassName = serviceBeanDefinition.getBeanClassName();
        try {
            Class beanClass = ClassUtils.forName((String)beanClassName, (ClassLoader)beanClassLoader);
            return ClassUtils.getAllInterfacesForClass((Class)beanClass, (ClassLoader)beanClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Cannot find bean class '%s'.", beanClassName), e);
        }
        catch (LinkageError e) {
            throw new RuntimeException(String.format("Cannot find bean class '%s'.", beanClassName), e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    public void setBackwardsComaptible(boolean backwardsComaptible) {
        this.backwardsComaptible = backwardsComaptible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setExceptionLogLevel(Level exceptionLogLevel) {
        this.exceptionLogLevel = exceptionLogLevel;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }
}

