/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.IJsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.spring.rest.MappingJacksonRPC2HttpMessageConverter;
import com.googlecode.jsonrpc4j.spring.rest.SslClientHttpRequestFactory;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JsonRpcRestClient
extends JsonRpcClient
implements IJsonRpcClient {
    private URL serviceUrl;
    private RestTemplate restTemplate;
    private final Map<String, String> headers = new HashMap<String, String>();
    private SslClientHttpRequestFactory requestFactory = null;

    public JsonRpcRestClient(URL serviceUrl) {
        this(serviceUrl, new ObjectMapper());
    }

    public JsonRpcRestClient(URL serviceUrl, Map<String, String> headers) {
        this(serviceUrl, new ObjectMapper(), headers);
    }

    public JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper, Map<String, String> headers) {
        this(serviceUrl, mapper, null, headers);
    }

    public JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper) {
        this(serviceUrl, mapper, null, new HashMap<String, String>());
    }

    public JsonRpcRestClient(URL serviceUrl, RestTemplate restTemplate) {
        this(serviceUrl, new ObjectMapper(), restTemplate, null);
    }

    public JsonRpcRestClient(URL serviceUrl, ObjectMapper mapper, RestTemplate restTemplate, Map<String, String> headers) {
        super(mapper);
        this.restTemplate = restTemplate != null ? restTemplate : new RestTemplate();
        this.serviceUrl = serviceUrl;
        if (headers != null) {
            this.headers.putAll(headers);
        }
        this.initRestTemplate();
    }

    public void setConnectionProxy(Proxy connectionProxy) {
        this.getRequestFactory().setProxy(connectionProxy);
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.getRequestFactory().setConnectTimeout(connectionTimeoutMillis);
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.getRequestFactory().setReadTimeout(readTimeoutMillis);
    }

    private SslClientHttpRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            this.requestFactory = new SslClientHttpRequestFactory();
        }
        return this.requestFactory;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }

    public void setSslContext(SSLContext sslContext) {
        if (sslContext != null) {
            this.getRequestFactory().setSslContext(sslContext);
        }
    }

    public void setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        if (hostNameVerifier != null) {
            this.getRequestFactory().setHostNameVerifier(hostNameVerifier);
        }
    }

    @Override
    public void invoke(String methodName, Object argument) throws Throwable {
        this.invoke(methodName, argument, null, new HashMap<String, String>());
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType) throws Throwable {
        return this.invoke(methodName, argument, returnType, new HashMap<String, String>());
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz));
    }

    @Override
    public <T> T invoke(String methodName, Object argument, Class<T> clazz, Map<String, String> extraHeaders) throws Throwable {
        return (T)this.invoke(methodName, argument, (Type)Type.class.cast(clazz), extraHeaders);
    }

    @Override
    public Object invoke(String methodName, Object argument, Type returnType, Map<String, String> extraHeaders) throws Throwable {
        ObjectNode request = super.createRequest(methodName, argument);
        LinkedMultiValueMap httpHeaders = new LinkedMultiValueMap();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpHeaders.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        if (extraHeaders != null) {
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                httpHeaders.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.requestFactory != null && this.restTemplate.getRequestFactory() != this.requestFactory) {
            this.restTemplate.setRequestFactory((ClientHttpRequestFactory)this.requestFactory);
        }
        HttpEntity requestHttpEntity = new HttpEntity((Object)request, (MultiValueMap)httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(this.serviceUrl.toURI(), (Object)requestHttpEntity, ObjectNode.class);
        Object response = this.readResponse(returnType, (ObjectNode)responseEntity.getBody());
        return response;
    }

    private void initRestTemplate() {
        boolean isContaintsConverter = false;
        for (HttpMessageConverter httpMessageConverter : this.restTemplate.getMessageConverters()) {
            if (!MappingJacksonRPC2HttpMessageConverter.class.isAssignableFrom(httpMessageConverter.getClass())) continue;
            isContaintsConverter = true;
            break;
        }
        if (!isContaintsConverter) {
            MappingJacksonRPC2HttpMessageConverter messageConverter = new MappingJacksonRPC2HttpMessageConverter();
            messageConverter.setObjectMapper(this.getObjectMapper());
            ArrayList<MappingJacksonRPC2HttpMessageConverter> restMessageConverters = new ArrayList<MappingJacksonRPC2HttpMessageConverter>();
            restMessageConverters.addAll(this.restTemplate.getMessageConverters());
            restMessageConverters.add(0, messageConverter);
            this.restTemplate.setMessageConverters(restMessageConverters);
        }
    }
}

