/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.velocity;

import com.google.javascript.jscomp.CompilationLevel;
import com.googlecode.htmlcompressor.compressor.ClosureJavaScriptCompressor;
import com.googlecode.htmlcompressor.compressor.YuiJavaScriptCompressor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.parser.node.Node;

public class JavaScriptCompressorDirective
extends Directive {
    private Log log;
    private boolean enabled = true;
    private String jsCompressor = "yui";
    private boolean yuiJsNoMunge;
    private boolean yuiJsPreserveAllSemiColons;
    private boolean yuiJsDisableOptimizations;
    private int yuiJsLineBreak = -1;
    private String closureOptLevel = "simple";

    public String getName() {
        return "compressJs";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        this.enabled = rs.getBoolean("userdirective.compressJs.enabled", true);
        this.jsCompressor = rs.getString("userdirective.compressHtml.jsCompressor", "yui");
        this.yuiJsNoMunge = rs.getBoolean("userdirective.compressJs.yuiJsNoMunge", false);
        this.yuiJsPreserveAllSemiColons = rs.getBoolean("userdirective.compressJs.yuiJsPreserveAllSemiColons", false);
        this.yuiJsLineBreak = rs.getInt("userdirective.compressJs.yuiJsLineBreak", -1);
        this.closureOptLevel = rs.getString("userdirective.compressHtml.closureOptLevel", "simple");
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        if (this.enabled) {
            try {
                String result = content.toString();
                if (this.jsCompressor.equalsIgnoreCase("closure")) {
                    ClosureJavaScriptCompressor closureCompressor = new ClosureJavaScriptCompressor();
                    if (this.closureOptLevel.equalsIgnoreCase("advanced")) {
                        closureCompressor.setCompilationLevel(CompilationLevel.ADVANCED_OPTIMIZATIONS);
                    } else if (this.closureOptLevel.equalsIgnoreCase("whitespace")) {
                        closureCompressor.setCompilationLevel(CompilationLevel.WHITESPACE_ONLY);
                    } else {
                        closureCompressor.setCompilationLevel(CompilationLevel.SIMPLE_OPTIMIZATIONS);
                    }
                    result = closureCompressor.compress(result);
                } else {
                    YuiJavaScriptCompressor yuiCompressor = new YuiJavaScriptCompressor();
                    yuiCompressor.setDisableOptimizations(this.yuiJsDisableOptimizations);
                    yuiCompressor.setLineBreak(this.yuiJsLineBreak);
                    yuiCompressor.setNoMunge(this.yuiJsNoMunge);
                    yuiCompressor.setPreserveAllSemiColons(this.yuiJsPreserveAllSemiColons);
                    result = yuiCompressor.compress(result);
                }
                writer.write(result);
            }
            catch (Exception e) {
                writer.write(content.toString());
                String msg = "Failed to compress content: " + content.toString();
                this.log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        } else {
            writer.write(content.toString());
        }
        return true;
    }
}

