/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.bs;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.pinyin.api.IPinyin;
import com.github.houbb.pinyin.api.IPinyinContext;
import com.github.houbb.pinyin.api.impl.Pinyin;
import com.github.houbb.pinyin.api.impl.PinyinContext;
import com.github.houbb.pinyin.spi.IPinyinChinese;
import com.github.houbb.pinyin.spi.IPinyinData;
import com.github.houbb.pinyin.spi.IPinyinSegment;
import com.github.houbb.pinyin.spi.IPinyinTone;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.chinese.PinyinChineses;
import com.github.houbb.pinyin.support.data.PinyinData;
import com.github.houbb.pinyin.support.segment.PinyinSegments;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import com.github.houbb.pinyin.support.tone.PinyinTones;
import java.util.List;

public final class PinyinBs {
    private IPinyinSegment pinyinSegment = PinyinSegments.defaults();
    private final IPinyinChinese pinyinChinese = PinyinChineses.defaults();
    private final IPinyinTone pinyinTone = PinyinTones.defaults();
    private final IPinyinData data = (IPinyinData)Instances.singleton(PinyinData.class);
    private IPinyinToneStyle style = PinyinToneStyles.defaults();
    private final IPinyin pinyin = (IPinyin)Instances.singleton(Pinyin.class);
    private String connector = " ";

    private PinyinBs() {
    }

    public static PinyinBs newInstance() {
        return new PinyinBs();
    }

    public PinyinBs style(IPinyinToneStyle style) {
        ArgUtil.notNull((Object)style, (String)"style");
        this.style = style;
        return this;
    }

    public PinyinBs connector(String connector) {
        this.connector = connector;
        return this;
    }

    public PinyinBs segment(IPinyinSegment pinyinSegment) {
        ArgUtil.notNull((Object)pinyinSegment, (String)"segment");
        this.pinyinSegment = pinyinSegment;
        return this;
    }

    public String toPinyin(String string) {
        if (StringUtil.isEmpty((String)string)) {
            return string;
        }
        return this.pinyin.toPinyin(string, this.buildPinyinContext());
    }

    public List<String> toPinyinList(char chinese) {
        return this.pinyin.toPinyinList(chinese, this.buildPinyinContext());
    }

    public boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return this.pinyin.hasSamePinyin(chineseOne, chineseTwo, this.buildPinyinContext());
    }

    public List<Integer> toneNumList(String chinese) {
        return this.pinyin.toneNumList(chinese, this.buildPinyinContext());
    }

    public List<Integer> toneNumList(char chinese) {
        return this.pinyin.toneNumList(chinese, this.buildPinyinContext());
    }

    public List<String> shengMuList(String chinese) {
        return this.pinyin.shengMuList(chinese, this.buildPinyinContext());
    }

    public List<String> yunMuList(String chinese) {
        return this.pinyin.yunMuList(chinese, this.buildPinyinContext());
    }

    private IPinyinContext buildPinyinContext() {
        return PinyinContext.newInstance().chinese(this.pinyinChinese).data(this.data).segment(this.pinyinSegment).style(this.style).tone(this.pinyinTone).connector(this.connector);
    }
}

