/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.tone;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.pinyin.constant.enums.PinyinToneNumEnum;
import com.github.houbb.pinyin.model.CharToneInfo;
import com.github.houbb.pinyin.model.ToneItem;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.tone.AbstractPinyinTone;
import com.github.houbb.pinyin.util.ToneHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class DefaultPinyinTone
extends AbstractPinyinTone {
    private static volatile Map<String, List<String>> charMap;
    private static volatile Map<String, String> phraseMap;

    @Override
    protected List<String> getCharTones(String chinese, final IPinyinToneStyle toneStyle) {
        List<String> defaultList = this.getCharMap().get(chinese);
        return CollectionUtil.toList(defaultList, (IHandler)new IHandler<String, String>(){

            public String handle(String s) {
                return toneStyle.style(s);
            }
        });
    }

    @Override
    protected String getCharTone(String segment, IPinyinToneStyle toneStyle) {
        List<String> pinyinList = this.getCharMap().get(segment);
        if (CollectionUtil.isNotEmpty(pinyinList)) {
            String firstPinyin = pinyinList.get(0);
            return toneStyle.style(firstPinyin);
        }
        return null;
    }

    @Override
    protected String getPhraseTone(String segment, IPinyinToneStyle toneStyle, String connector) {
        String phrasePinyin = this.getPhraseMap().get(segment);
        if (StringUtil.isEmptyTrim((String)phrasePinyin)) {
            return "";
        }
        String[] strings = phrasePinyin.split(" ");
        List resultList = Guavas.newArrayList((int)strings.length);
        for (String string : strings) {
            String style = toneStyle.style(string);
            resultList.add(style);
        }
        return StringUtil.join((Collection)resultList, (String)connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<String>> getCharMap() {
        if (ObjectUtil.isNotNull(charMap)) {
            return charMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtil.isNull(charMap)) {
                long startTime = System.currentTimeMillis();
                List lines = StreamUtil.readAllLines((String)"/pinyin_dict_char.txt");
                List defineLines = StreamUtil.readAllLines((String)"/pinyin_dict_char_define.txt");
                lines.addAll(defineLines);
                charMap = Guavas.newHashMap((int)lines.size());
                for (String line : lines) {
                    String[] strings = line.split(":");
                    List pinyinList = StringUtil.splitToList((String)strings[1]);
                    String word = strings[0];
                    charMap.put(word, pinyinList);
                }
                long endTime = System.currentTimeMillis();
                System.out.println("[Pinyin] char dict loaded, cost time " + (endTime - startTime) + " ms!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return charMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPhraseMap() {
        if (ObjectUtil.isNotNull(phraseMap)) {
            return phraseMap;
        }
        Class<DefaultPinyinTone> clazz = DefaultPinyinTone.class;
        synchronized (DefaultPinyinTone.class) {
            if (ObjectUtil.isNull(phraseMap)) {
                long startTime = System.currentTimeMillis();
                List lines = StreamUtil.readAllLines((String)"/pinyin_dict_phrase.txt");
                List defineLines = StreamUtil.readAllLines((String)"/pinyin_dict_phrase_define.txt");
                lines.addAll(defineLines);
                phraseMap = Guavas.newHashMap((int)lines.size());
                for (String line : lines) {
                    String[] strings = line.split(":");
                    String word = strings[0];
                    phraseMap.put(word, strings[1]);
                }
                long endTime = System.currentTimeMillis();
                System.out.println("[Pinyin] phrase dict loaded, cost time " + (endTime - startTime) + " ms!");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return phraseMap;
        }
    }

    @Override
    public Set<String> phraseSet() {
        Map<String, String> map = this.getPhraseMap();
        return map.keySet();
    }

    @Override
    public int toneNum(String defaultPinyin) {
        if (StringUtil.isNotEmpty((String)defaultPinyin)) {
            CharToneInfo toneInfo = this.getCharToneInfo(defaultPinyin);
            int index = toneInfo.getIndex();
            if (index < 0) {
                return PinyinToneNumEnum.FIVE.num();
            }
            return toneInfo.getToneItem().getTone();
        }
        return PinyinToneNumEnum.UN_KNOWN.num();
    }

    protected CharToneInfo getCharToneInfo(String tone) {
        CharToneInfo charToneInfo = new CharToneInfo();
        charToneInfo.setIndex(-1);
        int length = tone.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = tone.charAt(i);
            ToneItem toneItem = ToneHelper.getToneItem(currentChar);
            if (!ObjectUtil.isNotNull((Object)toneItem)) continue;
            charToneInfo.setToneItem(toneItem);
            charToneInfo.setIndex(i);
            break;
        }
        return charToneInfo;
    }
}

