/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.model;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;

public class PageVo<T>
implements Serializable {
    private static final long serialVersionUID = 1923401118856169487L;
    private Long total;
    private String url;
    private Integer pageIndex;
    private Integer pageSize;
    private List<T> items;
    private int displayEntries = 5;
    private int edgeEntries = 1;

    public PageVo() {
    }

    public PageVo(Long total, Integer pageIndex, Integer pageSize, List<T> items) {
        this.total = total;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.items = items;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public String toString() {
        return "PageVo [total=" + this.total + ", pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", items=" + this.items + "]";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNavigation() {
        String str;
        int i;
        Integer totalPage = (int)(this.total % (long)this.pageSize.intValue() > 0L ? this.total / (long)this.pageSize.intValue() + 1L : this.total / (long)this.pageSize.intValue());
        int ne_half = (this.displayEntries & 1) == 1 ? (this.displayEntries >> 1) + 1 : this.displayEntries >> 1;
        int upper_limit = totalPage - this.displayEntries;
        this.pageIndex = this.pageIndex < 1 ? 1 : this.pageIndex;
        int currentPage = this.pageIndex - 1;
        int start = currentPage > ne_half ? Math.max(Math.min(currentPage - ne_half, upper_limit), 0) : 0;
        int end = currentPage > ne_half ? Math.min(currentPage + ne_half, totalPage) : Math.min(this.displayEntries, totalPage);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div\tid=\"pagination\" class=\"pagination\">");
        if (this.pageIndex == 1 || totalPage == 0) {
            buffer.append("<span class=\"disabled\">\u4e0a\u4e00\u9875</span>");
        } else {
            String str2 = MessageFormat.format("<a href=\"" + this.url + "\"", this.pageIndex - 1);
            buffer.append(str2).append(">\u4e0a\u4e00\u9875</a>");
        }
        if (start > 0 && this.edgeEntries > 0) {
            int end1 = Math.min(this.edgeEntries, start);
            for (i = 0; i < end1; ++i) {
                str = MessageFormat.format("<a href=\"" + this.url + "\"", i + 1);
                buffer.append(str).append(">").append(i + 1).append("</a>");
            }
            if (this.edgeEntries < start) {
                buffer.append("<span>...</span>");
            }
        }
        for (int i2 = start; i2 < end; ++i2) {
            if (i2 + 1 == this.pageIndex) {
                buffer.append("<span class=\"current\">").append(i2 + 1).append("</span>");
                continue;
            }
            String str3 = MessageFormat.format("<a href=\"" + this.url + "\"", i2 + 1);
            buffer.append(str3).append(">").append(i2 + 1).append("</a>");
        }
        if (end < totalPage && this.edgeEntries > 0) {
            int begin;
            if (totalPage - this.edgeEntries > end) {
                buffer.append("<span>...</span>");
            }
            for (i = begin = Math.max(totalPage - this.edgeEntries, end); i < totalPage; ++i) {
                str = MessageFormat.format("<a href=\"" + this.url + "\"", i + 1);
                buffer.append(str).append(">").append(i + 1).append("</a>");
            }
        }
        if (this.pageIndex == totalPage || totalPage == 0) {
            buffer.append("<span class=\"disabled\">\u4e0b\u4e00\u9875</span>");
        } else {
            String str4 = MessageFormat.format("<a href=\"" + this.url + "\"", this.pageIndex + 1);
            buffer.append(str4).append(">\u4e0b\u4e00\u9875</a>");
        }
        buffer.append("</div>");
        return buffer.toString();
    }
}

